% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{map_data_}
\alias{map_data_}
\title{Create a mapping without NSE}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object.}

\item{from}{The value used to name the output. There will be one output value
for each value in \code{from}.}

\item{to}{The value returned in the output.}
}
\value{
A vector of \code{to} values named by values in \code{from}.
}
\description{
Creates a named vector that maps the values of two variables associated with
taxa in a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object without using Non-Standard
Evaluation (NSE). Both values must be named by taxon ids. This is the same as
\code{\link[=map_data]{map_data()}} without NSE and can be useful in some odd cases where NSE fails
to work as expected.
\preformatted{
obj$map_data(from, to)
map_data(obj, from, to)}
}
\examples{
x = c("d" = "looks like a cat", "h" = "big scary cats",
      "i" = "smaller cats", "m" = "might eat you", "n" = "Meow! (Feed me!)")
map_data_(ex_taxmap, from = ex_taxmap$taxon_names(), to = x)

}
\seealso{
Other taxonomy data functions: \code{\link{classifications}},
  \code{\link{id_classifications}},
  \code{\link{is_branch}}, \code{\link{is_internode}},
  \code{\link{is_leaf}}, \code{\link{is_root}},
  \code{\link{is_stem}}, \code{\link{map_data}},
  \code{\link{n_leaves_1}}, \code{\link{n_leaves}},
  \code{\link{n_subtaxa_1}}, \code{\link{n_subtaxa}},
  \code{\link{n_supertaxa_1}}, \code{\link{n_supertaxa}},
  \code{\link{taxon_ids}}, \code{\link{taxon_indexes}},
  \code{\link{taxon_names}}, \code{\link{taxon_ranks}}
}
