% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{branches}
\alias{branches}
\title{Get "branch" taxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes used to subset
the tree prior to determining branches. Default: All taxa in \code{obj} will be
used. Any variable name that appears in \code{\link[=all_names]{all_names()}} can be used as if it
was a vector on its own. Note that branches are determined after the
filtering, so a given taxon might be a branch on the unfiltered tree, but
not a branch on the filtered tree.}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{\link[=all_names]{all_names()}} can be used, but it
usually only makes sense to use data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}
}
\value{
\code{character}
}
\description{
Return the "branch" taxa for a \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object. A branch is
anything that is not a root, stem, or leaf. Its the interior of the tree
after the first split starting from the roots. Can also be used to get the
branches of a subset of taxa.
\preformatted{
obj$branches(subset = NULL, value = "taxon_indexes")
branches(obj, subset = NULL, value = "taxon_indexes")}
}
\examples{
# Return indexes of branch taxa
branches(ex_taxmap)

# Return indexes for a subset of taxa
branches(ex_taxmap, subset = 2:17)
branches(ex_taxmap, subset = n_obs > 1)

# Return something besides taxon indexes
branches(ex_taxmap, value = "taxon_names")

}
\seealso{
Other taxonomy indexing functions: \code{\link{internodes}},
  \code{\link{leaves}}, \code{\link{roots}},
  \code{\link{stems}}, \code{\link{subtaxa}},
  \code{\link{supertaxa}}
}
\concept{taxonomy indexing functions}
