% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/get_nbnid.R
\name{get_nbnid}
\alias{as.data.frame.nbnid}
\alias{as.nbnid}
\alias{as.nbnid.character}
\alias{as.nbnid.data.frame}
\alias{as.nbnid.list}
\alias{as.nbnid.nbnid}
\alias{get_nbnid}
\alias{get_nbnid_}
\title{Get the UK National Biodiversity Network ID from taxonomic names.}
\usage{
get_nbnid(name, ask = TRUE, verbose = TRUE, rec_only = FALSE,
  rank = NULL, rows = NA, ...)

as.nbnid(x, check = TRUE)

\method{as.nbnid}{nbnid}(x, check = TRUE)

\method{as.nbnid}{character}(x, check = TRUE)

\method{as.nbnid}{list}(x, check = TRUE)

\method{as.nbnid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{nbnid}(x, ...)

get_nbnid_(name, verbose = TRUE, rec_only = FALSE, rank = NULL,
  rows = NA, ...)
}
\arguments{
\item{name}{character; scientific name.}

\item{ask}{logical; should get_nbnid be run in interactive mode?
If TRUE and more than one ID is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the
console.}

\item{rec_only}{(logical) If \code{TRUE} ids of recommended names are returned (i.e.
synonyms are removed). Defaults to \code{FALSE}. Remember, the id of a synonym is a
taxa with 'recommended' name status.}

\item{rank}{(character) If given, we attempt to limit the results to those taxa with the
matching rank.}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a nbnid class object with one to many identifiers.
See \code{\link[taxize]{get_nbnid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{...}{Further args passed on to \code{nbn_search}}

\item{x}{Input to \code{\link{as.nbnid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.nbnid}}}
}
\value{
A vector of unique identifiers. If a taxon is not found NA.
If more than one ID is found the function asks for user input.
}
\description{
Get the UK National Biodiversity Network ID from taxonomic names.
}
\examples{
\dontrun{
get_nbnid(name='Poa annua')
get_nbnid(name='Poa annua', rec_only=TRUE)
get_nbnid(name='Poa annua', rank='Species')
get_nbnid(name='Poa annua', rec_only=TRUE, rank='Species')
get_nbnid(name='Pinus contorta')

# The NBN service handles common names too
get_nbnid(name='red-winged blackbird')

# specify rows to limit choices available
get_nbnid('Poa annua')
get_nbnid('Poa annua', rows=1)
get_nbnid('Poa annua', rows=25)
get_nbnid('Poa annua', rows=1:2)

# When not found
get_nbnid(name="uaudnadndj")
get_nbnid(c("Zootoca vivipara", "uaudnadndj"))
get_nbnid(c("Zootoca vivipara","Chironomus riparius", "uaudnadndj"))

# Convert an nbnid without class information to a nbnid class
as.nbnid(get_nbnid("Zootoca vivipara")) # already a nbnid, returns the same
as.nbnid(get_nbnid(c("Zootoca vivipara","Pinus contorta"))) # same
as.nbnid('NHMSYS0001706186') # character
as.nbnid(c("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867")) # character vector, length > 1
as.nbnid(list("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867")) # list
## dont check, much faster
as.nbnid('NHMSYS0001706186', check=FALSE)
as.nbnid(list("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867"), check=FALSE)

(out <- as.nbnid(c("NHMSYS0001706186","NHMSYS0000494848","NBNSYS0000010867")))
data.frame(out)
as.nbnid( data.frame(out) )

# Get all data back
get_nbnid_("Zootoca vivipara")
get_nbnid_("Poa annua", rows=2)
get_nbnid_("Poa annua", rows=1:2)
get_nbnid_(c("asdfadfasd","Pinus contorta"), rows=1:5)

# use curl options
library("httr")
get_nbnid("Quercus douglasii", config=verbose())
bb <- get_nbnid("Quercus douglasii", config=progress())
}
}
\author{
Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_uid}},
\code{\link[taxize]{get_tpsid}}, \code{\link[taxize]{get_eolid}}
}

