% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iucn_summary.R
\name{iucn_summary}
\alias{iucn_summary}
\alias{iucn_summary_id}
\alias{iucn_status.iucn}
\title{Get a summary from the IUCN Red List}
\usage{
iucn_summary(sciname, silent = TRUE, parallel = FALSE,
  distr_detail = FALSE, key = NULL, ...)

iucn_summary_id(species_id, silent = TRUE, parallel = FALSE,
  distr_detail = FALSE, ...)

\method{iucn_status}{iucn}(x, ...)
}
\arguments{
\item{sciname}{character; Scientific name. Should be cleaned and in the
format \emph{<Genus> <Species>}.}

\item{silent}{logical; Make errors silent or not (when species not found).}

\item{parallel}{logical; Search in parallel to speed up search. You have to
register a parallel backend if \code{TRUE}. See e.g., doMC, doSNOW, etc.}

\item{distr_detail}{logical; If \code{TRUE}, the geographic distribution is
returned as a list of vectors corresponding to the different range types:
native, introduced, etc.}

\item{key}{a Redlist API key, get one from \url{http://apiv3.iucnredlist.org/api/v3/token}
Required for \code{iucn_summary} but not needed for \code{iucn_summary_id}. Defaults to
\code{NULL} in case you have your key stored (see \code{Redlist Authentication} below).}

\item{...}{Currently not used.}

\item{species_id}{an IUCN ID}

\item{x}{an \code{iucn} object as returned by
\code{\link[taxize]{iucn_summary}}.}
}
\value{
A list (for every species one entry) of lists with the following
items:
\item{status}{Red List Category.}
\item{history}{History of status, if available.}
\item{distr}{Geographic distribution, if available.}
\item{trend}{Trend of population size, if available.}
}
\description{
Get a summary from the IUCN Red List (\url{http://www.iucnredlist.org/}).
}
\details{
Beware: IUCN functions can give back incorrect data. This isn't our fault.
We do our best to get you the correct data quickly, but sometimes IUCN gives
back the wrong data, and sometimes Global Names gives back the wrong data.
We will fix these as soon as possible. In the meantime, just make sure that
the data you get back is correct.
}
\note{
Not all entries (history, distr, trend) are available for every species
and NA is returned.
\code{\link[taxize]{iucn_status}} is an extractor function to easily extract
status into a vector.
}
\section{Redlist Authentication}{

\code{iucn_summary} uses the new Redlist API for searching for a IUCN ID, so we
use the \code{\link[rredlist]{rl_search}} function internally. This function
requires an API key. Get the key at \url{http://apiv3.iucnredlist.org/api/v3/token},
and pass it to the \code{key} parameter, or store in your \code{.Renviron} file like
\code{IUCN_REDLIST_KEY=yourkey} or in your \code{.Rprofile} file like
\code{options(iucn_redlist_key="yourkey"}. We strongly encourage you to not pass
the key in the function call but rather store it in one of those two files.
This key will also set you up to use the \pkg{rredlist} package.
}

\examples{
\dontrun{
# if you send a taxon name, an IUCN API key is required
## here, the key is being detected from a .Rprofile file
## or .Renviron file, See "Redlist Authentication" above
iucn_summary("Lutra lutra")

ia <- iucn_summary(c("Panthera uncia", "Lynx lynx"))
ia <- iucn_summary(c("Panthera uncia", "Lynx lynx", "aaa"))

## get detailed distribution
iac <- iucn_summary("Ara chloropterus", distr_detail = TRUE)
iac[[1]]$distr


# If you pass in an IUCN ID, you don't need to pass in a Redlist API Key
ia <- iucn_summary_id(c(22732, 12519))
# extract status
iucn_status(ia)
# extract other available information
ia[['Lynx lynx']]$history
ia[['Panthera uncia']]$distr
ia[[2]]$trend

# using parallel, e.g., with doMC package, register cores first
# library(doMC)
# registerDoMC(cores = 2)
# nms <- c("Panthera uncia", "Lynx lynx", "Ara chloropterus", "Lutra lutra")
# (res <- iucn_summary(nms, parallel = TRUE))
}
}
\seealso{
\code{\link[taxize]{iucn_status}}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}

Philippe Marchand, \email{marchand.philippe@gmail.com}

Scott Chamberlain, \email{myrmecocystus@gmail.com}
}
