% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_x.R
\name{replace_x}
\alias{replace_x}
\alias{replace_idx}
\alias{replace_na}
\alias{insert_rows}
\title{Data manipulation.}
\usage{
replace_x(x, old, new)

replace_idx(x, idx1, idx2, new)

replace_na(x, idx1, idx2, new)

insert_rows(x, y)
}
\arguments{
\item{x}{A vector to be modified or a data frame in the case of
\code{insert_rows}.}

\item{old, new}{Vectors containing the values to be replaced and the updated
values, respectively.}

\item{idx1, idx2}{Indices applied for the values in 'x' and the values to be
replaced, respectively.}

\item{y}{Data frame including rows to be inserted in \code{x}.}
}
\value{
A vector or data frame with the modified values.
}
\description{
Functions provided for fast replacement and update of data.
}
\details{
These are functions implemented for efficient coding of insert and replace
routines.

The functions \code{replace_x} and \code{replace_idx} replace values in vectors,
in the first case comparing values in the vector and in the second one by
using indices.
The function \code{replace_na} works in the same way as \code{replace_idx}, but
carries out the replacement only if the previous value is a \code{NA}.

The function \code{insert_rows} inserts \code{y} as new rows in \code{x}. If \code{y} contains
columns absent in \code{x}, they will be added to the output data frame.
}
\examples{
library(taxlist)

## Replace values in vector
replace_x(letters, c("b", "p", "f"), c("bee", "pork", "fungus"))

## Replace values using indices
replace_idx(letters, 1:length(letters), c(2,7,17), c("second", "seven",
    "seventeenth"))

## Replace values if they are NAs
letters[2] <- NA
replace_na(letters, 1:length(letters), c(1:3), c("alpha", "beta", "zeta"))

## Merge data frames including new columns
data(iris)
iris$Species <- paste(iris$Species)
new_iris <- data.frame(Species=rep("humilis", 2), Height=c(15,20),
    stringsAsFactors=FALSE)
insert_rows(iris, new_iris)

}
\author{
Miguel Alvarez.
}
