% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki2taxo.R
\name{wiki2taxo}
\alias{wiki2taxo}
\title{Wikipedia list to taxo}
\usage{
wiki2taxo(wikisyn)
}
\arguments{
\item{wikisyn}{Wikipedia synonyms list}
}
\value{
taxolist
}
\description{
Converts the output of \link{list_wiki_syn} function to
taxolist format of \link{taxotools} package
}
\details{
Output of \link{list_wiki_syn} function has different format
than taxolist. This function converts it making sure to add additional
fields and maintain the synonym linkages.
}
\examples{
\donttest{
 wikilist <- data.frame("Name" = c("Abrothrix illutea",
                                   "Abrothrix illutea"),
                        "WikiName" = c("Abrothrix illuteus",
                                       "Abrothrix illuteus"),
                        "OrigSyn" = c("Akodon illuteus",
                                      "Abrothrix illuteus"),
                        "Syn" = c("Akodon illuteus",
                                  "Abrothrix illuteus"))
 wiki2taxo(wikilist)
}
}
\seealso{
Other List functions: 
\code{\link{DwC2taxo}()},
\code{\link{cast_cs_field}()},
\code{\link{compact_ids}()},
\code{\link{get_synonyms}()},
\code{\link{match_lists}()},
\code{\link{melt_cs_field}()},
\code{\link{merge_lists}()},
\code{\link{syn2taxo}()},
\code{\link{synonymize_subspecies}()},
\code{\link{taxo2DwC}()},
\code{\link{taxo2doc}()},
\code{\link{taxo2syn}()}
}
\concept{List functions}
