% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cosine.similarity}
\alias{cosine.similarity}
\alias{jaccard.index}
\alias{morisitas.index}
\alias{overlap.coef}
\alias{similarity}
\alias{tversky.index}
\title{Set and vector similarity measures.}
\usage{
cosine.similarity(.alpha, .beta, .do.norm = NA, .laplace = 0)

tversky.index(x, y, .a = 0.5, .b = 0.5)

overlap.coef(.alpha, .beta)

jaccard.index(.alpha, .beta, .intersection.number = NA)

morisitas.index(.alpha, .beta, .do.unique = T)
}
\arguments{
\item{.alpha,.beta,x,y}{Vector of numeric values for cosine similarity, vector of any values
(like characters) for tversky.index and overlap.coef, matrix or data.frame with 2 columns for morisitas.index,
either sets or number of elements in sets for Jaccard index (see "Details" section).}

\item{.do.norm}{One of the three values - NA, T or F. If NA than check for distrubution (sum(.data) == 1)
and normalise if needed with the given laplace correction value. If T than do normalisation and laplace
correction. If F than don't do normalisaton and laplace correction.}

\item{.laplace}{Value for Laplace correction.}

\item{.a,.b}{Alpha and beta parameters for Tversky Index. Default values gives the Jaccard index measure.}

\item{.do.unique}{If T than call unique on the first columns of the given data.frame or matrix.}

\item{.intersection.number}{Number of intersected elements between two sets. See "Details" for more information.}
}
\value{
Value of similarity between the given sets or vectors.
}
\description{
Functions for computing similarity between two vectors or sets. See "Details" for exact formulas.

- Cosine similarity is a measure of similarity between two vectors of an inner product space that measures the cosine of the angle between them.

- Tversky index is an asymmetric similarity measure on sets that compares a variant to a prototype.

- Overlap cofficient is a similarity measure related to the Jaccard index that measures the overlap between two sets, and is defined as the size of the intersection divided by the smaller of the size of the two sets.

- Jaccard index is a statistic used for comparing the similarity and diversity of sample sets.

- Morisita's overlap index is a statistical measure of dispersion of individuals in a population. It is used to compare overlap among samples (Morisita 1959). This formula is based on the assumption that increasing the size of the samples will increase the diversity because it will include different habitats (i.e. different faunas).
}
\details{
For \code{morisitas.index} input data are matrices or data.frames with two columns: first column is
elements (species or individuals), second is a number of elements (species or individuals) in a population.

For \code{jaccard.index} there are two ways for computing the index. ???

Formulas:

Cosine similarity: \code{cos(a, b) = a * b / (||a|| * ||b||)}

Tversky index: \code{S(X, Y) = |X and Y| / (|X and Y| + a*|X - Y| + b*|Y - X|)}

Overlap coefficient: \code{overlap(X, Y) = |X and Y| / min(|X|, |Y|)}

Jaccard index: \code{J(A, B) = |A and B| / |A U B|}

Formual for Morisita's overlap index is quite complicated and can't be easily shown here, so just look at webpage: http://en.wikipedia.org/wiki/Morisita%27s_overlap_index
}
\examples{
\dontrun{
jaccard.index(1:10, 2:20)
a <- length(unique(immdata[[1]][, c('CDR3.amino.acid.sequence', 'V.segments')]))
b <- length(unique(immdata[[2]][, c('CDR3.amino.acid.sequence', 'V.segments')]))
jaccard.index(a, b, intersect(immdata[[1]], immdata[[2]], 'ave'))
}
}
\seealso{
\link{intersect}, \link{entropy}, \link{diversity}
}

