% Generated by roxygen2 (4.0.2): do not edit by hand
\name{get.kmers}
\alias{get.kmers}
\title{Get kmers from sequences.}
\usage{
get.kmers(.data, .head = -1, .k = 5, .clean = T, .meat = F,
  .verbose = T, .left.shift = 0, .right.shift = 0)
}
\arguments{
\item{.data}{Either character vector or a data.frame.}

\item{.head}{Parameter for head function applied to the given data before kmer generation.}

\item{.k}{Size of the kmer.}

\item{.clean}{If T than remove sequences which contain '~' or '*' symbols. Useful for deleting out-of-frame aminoacid sequnces.}

\item{.meat}{if TRUE than .data must be data.frame with columns CDR3.amino.acid.sequence and Read.count.}

\item{.verbose}{If T than print progress.}

\item{.left.shift}{Cut all \code{.left.shift} symbols from the left side for each sequence.}

\item{.right.shift}{Cut all \code{.right.shift} symbols from the right side for each sequence.}
}
\value{
Data.frame with 2 columns Kmers and Count / Rank / Percentage relatively to the .value param
or a list with such data.frames if .data is a list.
}
\description{
Get vector of kmers from the given character vector or data frame.
}

