% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_mods.R
\name{predict_pkmod}
\alias{predict_pkmod}
\title{Predict concentrations from a pkmod object - can be a user defined function}
\usage{
predict_pkmod(
  object,
  ...,
  inf,
  tms = NULL,
  dtm = 1/6,
  return_init = FALSE,
  remove_bounds = TRUE
)
}
\arguments{
\item{object}{An object with class pkmod.}

\item{...}{Arguments passed on to pkmod}

\item{inf}{An infusion schedule object with columns "begin","end","infrt".}

\item{tms}{Times to evaluate predictions at. Will default to a sequence
spanning the infusions at intervals of dtm.}

\item{dtm}{Interval used for prediction if argument tms is unspecified.}

\item{return_init}{Logical indicating if concentrations at time 0 should
be returned. Defaults to FALSE.}

\item{remove_bounds}{Logical, indicating if concentrations calculated at
changes in infusion rates should be returned if not included in prediction
times. Defaults to TRUE, so that only concentrations at specified times
are returned.}
}
\value{
Matrix of predicted concentrations associated with a pkmod object and
and infusion schedule.
}
\description{
Apply a PK model piecewise to infusion schedule
}
