# ------------------------------------------------------------------------------
# Generated by 'pre-generate/generate-steps.R': do not edit by hand.
# ------------------------------------------------------------------------------

dist_train <- data.frame(
  dist = I(list(eurodist))
)
dist_test <- data.frame(
  dist = I(list(UScitiesD))
)
dist_rec <- recipe(~ ., data = dist_train) |> 
  step_phom_point_cloud(everything(), keep_original_cols = FALSE)
scale_seq <- seq(0, 5000, 100)

test_that("`step_vpd_persistence_image()` agrees with raw function", {
  
  pl_rec <- dist_rec |> 
    step_vpd_persistence_image(
      everything(),
      xseq = scale_seq,
      yseq = scale_seq,
      hom_degree = 0, img_sigma = 10,
      keep_original_cols = FALSE
    )
  
  pl_prep <- prep(pl_rec, training = dist_train)
  
  pl_pred <- bake(pl_prep, new_data = dist_test) |> 
    unlist() |> unname()
  
  pl_exp <- dist_test$dist[[1L]] |> 
    ripserr::vietoris_rips() |> as.matrix() |> 
    TDAvec::computePersistenceImage(
      xSeq = scale_seq,
      ySeq = scale_seq,
      homDim = 0, sigma = 10
    ) |> 
    as.vector()
  
  expect_equal(pl_pred, pl_exp)
})

test_that("`tunable()` returns standard names", {
  
  pl_rec <- dist_rec |> 
    step_vpd_persistence_image(everything(), keep_original_cols = FALSE)
  tun <- tunable(pl_rec$steps[[2]])
  
  expect_equal(
    names(tun),
    c("name", "call_info", "source", "component", "component_id")
  )
  expect_equal(
    tun$name,
    c("hom_degree", "img_sigma")
  )
  expect_equal(unique(tun$source), "recipe")
  expect_true(is.list(tun$call_info))
})
