WarfDemo<-function(){
     cat("\n")
     cat("---------< Test Runs with Warfarin PK/PD Parameter Estimation >---------\n")
     cat("\n")
     cat("Scenario: A 65-year old male patient was taking warfarin 5 mg orally\n")
     cat("every day (24 hr) as antigoagulant purpose for more than one month.\n")
     cat("His body weight is 75 Kg. Supposed his INR value is measured as 5.67\n")
     cat("right before next dose. Now we like to estimate his PK/PD parameters.\n")
     cat("Dosage adjustment is omitted.\n")
     cat("\n")
     cat("\n")
     cat("\n")
     note_for_War_input()
     cat("\n")
     note_for_close_window()
     WarSSpar<-data.frame(parameter=c("D (mg)","tau (day)","INR"),value=c(0,0,0))
##     WarSSpar<-edit(WarSSpar)
##     WarSSpar<-wcheck(WarSSpar)
     cat("\n")
     WarSSpar[1,2]<-5
     WarSSpar[2,2]<-1
     WarSSpar[3,2]<-5.67
     War.ss(WarSSpar[1,2], WarSSpar[2,2], WarSSpar[3,2])
     note_for_convergence_plots()
     convergence_plots_war_sep()
     note_for_War_output()
     show(samplesStats("*"))
     cat("\n") 
     C<-Warcpr(WarSSpar[1,2],WarSSpar[2,2])
     Final<-(c(matrix(C[1 ,1]), WarSSpar[3,2]))
     coutput<-data.frame(Final)
     row.names(coutput)<-list("INR(calc)","INR(obs)")
     show(coutput)
     cat("\n")   
}