% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_t_abnormality_by_worst_grade.R
\name{tm_t_abnormality_by_worst_grade}
\alias{tm_t_abnormality_by_worst_grade}
\title{teal Module: Laboratory test results with highest grade post-baseline}
\usage{
tm_t_abnormality_by_worst_grade(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  id_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    subset = "USUBJID"), selected = "USUBJID", fixed = TRUE),
  paramcd,
  atoxgr_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, subset =
    "ATOXGR"), selected = "ATOXGR", fixed = TRUE),
  worst_high_flag_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, subset =
    "WGRHIFL"), selected = "WGRHIFL", fixed = TRUE),
  worst_low_flag_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, subset =
    "WGRLOFL"), selected = "WGRLOFL", fixed = TRUE),
  worst_flag_indicator = teal.transform::choices_selected("Y"),
  add_total = TRUE,
  total_label = default_total_label(),
  drop_arm_levels = TRUE,
  pre_output = NULL,
  post_output = NULL,
  basic_table_args = teal.widgets::basic_table_args()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for variable names that can be used as \code{arm_var}.
It defines the grouping variable(s) in the results table.
If there are two elements selected for \code{arm_var},
second variable will be nested under the first variable.}

\item{id_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object specifying
the variable name for subject id.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{atoxgr_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
object with all available choices and preselected option
for variable names that can be used as Analysis Toxicity Grade.}

\item{worst_high_flag_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
object with all available choices and preselected option for variable names that can be used as Worst High
Grade flag.}

\item{worst_low_flag_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
object with all available choices and preselected option for variable names that can be used as Worst Low Grade flag.}

\item{worst_flag_indicator}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr
value indicating worst grade.}

\item{add_total}{(\code{logical})\cr whether to include column with total number of patients.}

\item{total_label}{(\code{string})\cr string to display as total column/row label if column/row is
enabled (see \code{add_total}). Defaults to \code{"All Patients"}. To set a new default \code{total_label} to
apply in all modules, run \code{set_default_total_label("new_default")}.}

\item{drop_arm_levels}{(\code{logical})\cr whether to drop unused levels of \code{arm_var}. If \code{TRUE}, \code{arm_var} levels are
set to those used in the \code{dataname} dataset. If \code{FALSE}, \code{arm_var} levels are set to those used in the
\code{parentname} dataset. If \code{dataname} and \code{parentname} are the same, then \code{drop_arm_levels} is set to \code{TRUE} and
user input for this parameter is ignored.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{basic_table_args}{(\code{basic_table_args}) optional\cr object created by \code{\link[teal.widgets:basic_table_args]{teal.widgets::basic_table_args()}}
with settings for the module table. The argument is merged with option \code{teal.basic_table_args} and with default
module arguments (hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-basic-table-arguments", package = "teal.widgets")}.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces a table to summarize laboratory test results with highest grade post-baseline
}
\examples{
library(dplyr)

ADSL <- tmc_ex_adsl
ADLB <- tmc_ex_adlb \%>\%
  filter(!AVISIT \%in\% c("SCREENING", "BASELINE"))

app <- init(
  data = cdisc_data(
    ADSL = ADSL,
    ADLB = ADLB,
    code = "
      ADSL <- tmc_ex_adsl
      ADLB <- tmc_ex_adlb \%>\%
        filter(!AVISIT \%in\% c(\"SCREENING\", \"BASELINE\"))
    "
  ),
  modules = modules(
    tm_t_abnormality_by_worst_grade(
      label = "Laboratory Test Results with Highest Grade Post-Baseline",
      dataname = "ADLB",
      arm_var = choices_selected(
        choices = variable_choices(ADSL, subset = c("ARM", "ARMCD")),
        selected = "ARM"
      ),
      paramcd = choices_selected(
        choices = value_choices(ADLB, "PARAMCD", "PARAM"),
        selected = c("ALT", "CRP", "IGA")
      ),
      add_total = FALSE
    )
  ),
  filter = teal_slices(
    teal_slice("ADSL", "SAFFL", selected = "Y"),
    teal_slice("ADLB", "ONTRTFL", selected = "Y")
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
