% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportCard.R
\name{ReportCard}
\alias{ReportCard}
\title{\code{ReportCard}}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
R6 class that supports creating a report card containing text, plot, table and
meta data blocks that can be appended and rendered to form a report output from a shiny app.
}
\examples{

## ------------------------------------------------
## Method `ReportCard$new`
## ------------------------------------------------

card <- ReportCard$new()


## ------------------------------------------------
## Method `ReportCard$append_table`
## ------------------------------------------------

card <- ReportCard$new()$append_table(iris)


## ------------------------------------------------
## Method `ReportCard$append_plot`
## ------------------------------------------------

card <- ReportCard$new()$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)


## ------------------------------------------------
## Method `ReportCard$append_text`
## ------------------------------------------------

card <- ReportCard$new()$append_text("A paragraph of default text")


## ------------------------------------------------
## Method `ReportCard$append_rcode`
## ------------------------------------------------

card <- ReportCard$new()$append_rcode("2+2", echo = FALSE)


## ------------------------------------------------
## Method `ReportCard$append_content`
## ------------------------------------------------

NewpageBlock <- getFromNamespace("NewpageBlock", "teal.reporter")
card <- ReportCard$new()$append_content(NewpageBlock$new())


## ------------------------------------------------
## Method `ReportCard$get_content`
## ------------------------------------------------

card <- ReportCard$new()$append_text("Some text")$append_metadata("rc", "a <- 2 + 2")

card$get_content()



## ------------------------------------------------
## Method `ReportCard$get_metadata`
## ------------------------------------------------

card <- ReportCard$new()$append_text("Some text")$append_metadata("rc", "a <- 2 + 2")

card$get_metadata()


## ------------------------------------------------
## Method `ReportCard$append_metadata`
## ------------------------------------------------

card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()
card$get_metadata()


## ------------------------------------------------
## Method `ReportCard$get_name`
## ------------------------------------------------

ReportCard$new()$set_name("NAME")$get_name()

## ------------------------------------------------
## Method `ReportCard$set_name`
## ------------------------------------------------

ReportCard$new()$set_name("NAME")$get_name()

## ------------------------------------------------
## Method `ReportCard$to_list`
## ------------------------------------------------

card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()

card$to_list(tempdir())


## ------------------------------------------------
## Method `ReportCard$from_list`
## ------------------------------------------------

card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()

ReportCard$new()$from_list(card$to_list(tempdir()), tempdir())

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ReportCard-new}{\code{ReportCard$new()}}
\item \href{#method-ReportCard-append_table}{\code{ReportCard$append_table()}}
\item \href{#method-ReportCard-append_plot}{\code{ReportCard$append_plot()}}
\item \href{#method-ReportCard-append_text}{\code{ReportCard$append_text()}}
\item \href{#method-ReportCard-append_rcode}{\code{ReportCard$append_rcode()}}
\item \href{#method-ReportCard-append_content}{\code{ReportCard$append_content()}}
\item \href{#method-ReportCard-get_content}{\code{ReportCard$get_content()}}
\item \href{#method-ReportCard-reset}{\code{ReportCard$reset()}}
\item \href{#method-ReportCard-get_metadata}{\code{ReportCard$get_metadata()}}
\item \href{#method-ReportCard-append_metadata}{\code{ReportCard$append_metadata()}}
\item \href{#method-ReportCard-get_name}{\code{ReportCard$get_name()}}
\item \href{#method-ReportCard-set_name}{\code{ReportCard$set_name()}}
\item \href{#method-ReportCard-to_list}{\code{ReportCard$to_list()}}
\item \href{#method-ReportCard-from_list}{\code{ReportCard$from_list()}}
\item \href{#method-ReportCard-clone}{\code{ReportCard$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-new"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-new}{}}}
\subsection{Method \code{new()}}{
Returns a \code{ReportCard} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a \code{ReportCard} object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_table"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_table}{}}}
\subsection{Method \code{append_table()}}{
Appends a table to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_table(table)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{table}}{the appended table}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_table(iris)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_plot"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_plot}{}}}
\subsection{Method \code{append_plot()}}{
Appends a plot to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_plot(plot, dim = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot}}{the appended plot}

\item{\code{dim}}{\verb{integer vector} width and height in pixels.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_text"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_text}{}}}
\subsection{Method \code{append_text()}}{
Appends a paragraph of text to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_text(text, style = TextBlock$new()$get_available_styles()[1])}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(\code{character(0)} or \code{character(1)}) the text}

\item{\code{style}}{(\code{character(1)}) the style of the paragraph. One of: \code{default}, \code{header}, \code{verbatim}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("A paragraph of default text")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_rcode"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_rcode}{}}}
\subsection{Method \code{append_rcode()}}{
Appends an \code{rmarkdown} R chunk to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_rcode(text, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(\code{character(0)} or \code{character(1)}) the text}

\item{\code{...}}{any \code{rmarkdown} R chunk parameter and its value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_rcode("2+2", echo = FALSE)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_content"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_content}{}}}
\subsection{Method \code{append_content()}}{
Appends a \code{ContentBlock} to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_content(content)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content}}{(\code{ContentBlock})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{NewpageBlock <- getFromNamespace("NewpageBlock", "teal.reporter")
card <- ReportCard$new()$append_content(NewpageBlock$new())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-get_content"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-get_content}{}}}
\subsection{Method \code{get_content()}}{
Returns the content of this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$get_content()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{list()} list of \code{TableBlock}, \code{TextBlock} and \code{PictureBlock}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("Some text")$append_metadata("rc", "a <- 2 + 2")

card$get_content()


}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-reset"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-reset}{}}}
\subsection{Method \code{reset()}}{
Removes all objects added to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
invisibly self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Returns the metadata of this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$get_metadata()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\verb{named list} list of elements.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("Some text")$append_metadata("rc", "a <- 2 + 2")

card$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-append_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-append_metadata}{}}}
\subsection{Method \code{append_metadata()}}{
Appends metadata to this \code{ReportCard}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$append_metadata(key, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{(\code{character(1)}) name of meta data.}

\item{\code{value}}{value of meta data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()
card$get_metadata()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-get_name"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-get_name}{}}}
\subsection{Method \code{get_name()}}{
get the Card name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$get_name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character} a Card name
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ReportCard$new()$set_name("NAME")$get_name()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-set_name"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-set_name}{}}}
\subsection{Method \code{set_name()}}{
set the Card name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$set_name(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{\code{character} a Card name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ReportCard$new()$set_name("NAME")$get_name()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert the \code{ReportCard} to a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$to_list(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{character} with a path to the directory where files will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{named list} a \code{ReportCard} representation.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()

card$to_list(tempdir())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create the \code{ReportCard} from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$from_list(card, output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{card}}{\verb{named list} a \code{ReportCard} representation.}

\item{\code{output_dir}}{\code{character} with a path to the directory where a file will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisibly self
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{card <- ReportCard$new()$append_text("Some text")$append_plot(
  ggplot2::ggplot(iris, ggplot2::aes(x = Petal.Length)) + ggplot2::geom_histogram()
)$append_text("Some text")$append_metadata(key = "lm",
                  value = lm(Ozone ~ Solar.R, airquality))
card$get_content()

ReportCard$new()$from_list(card$to_list(tempdir()), tempdir())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ReportCard-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ReportCard-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ReportCard$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
