% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module_filter_manager.R
\name{filter_manager_module_srv}
\alias{filter_manager_module_srv}
\title{Module specific filter manager}
\usage{
filter_manager_module_srv(id, module_fd, slices_global)
}
\arguments{
\item{id}{(\code{character(1)})
\code{shiny} module id.}

\item{module_fd}{(\code{FilteredData})
Object containing the data to be filtered in a single \code{teal} module.}

\item{slices_global}{(\code{reactiveVal})
stores \code{teal_slices} with all available filters; allows the following actions:
\itemize{
\item to disable/enable a specific filter in a module
\item to restore saved filter settings
\item to save current filter panel settings
}}
}
\value{
A \code{reactive} expression containing the slices active in this module.
}
\description{
Tracks filter states in a single module.
}
\details{
This module tracks the state of a single \code{FilteredData} object and global \code{teal_slices}
and updates both objects as necessary. Filter states added in different modules
Filter states added any individual module are added to global \code{teal_slices}
and from there become available in other modules
by setting \code{private$available_teal_slices} in each \code{FilteredData}.
}
\keyword{internal}
