% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{por_transformation_df}
\alias{por_transformation_df}
\alias{geographical_to_PoR}
\alias{PoR_to_geographical}
\title{Conversion between spherical PoR to geographical coordinate system}
\usage{
geographical_to_PoR(x, PoR)

PoR_to_geographical(x, PoR)
}
\arguments{
\item{x}{\code{"data.frame"} containing \code{lat} and \code{lon}
coordinates of a point in the geographical CRS or the \code{lat.PoR},
\code{lon.PoR}) of the point in the PoR CRS.}

\item{PoR}{Pole of Rotation. \code{"data.frame"} or object of class \code{"euler.pole"}
containing the geographical coordinates of the Euler pole}
}
\value{
\code{"data.frame"} with the transformed coordinates
(\code{lat.PoR} and \code{lon.PoR} for PoR CRS,
or \code{lat} and \code{lon} for geographical CRS).
}
\description{
Transformation from spherical PoR to geographical coordinate system and
vice versa
}
\examples{
data("nuvel1")
por <- subset(nuvel1, nuvel1$plate.rot == "na") # North America relative to Pacific plate
data("san_andreas")
san_andreas.por <- geographical_to_PoR(san_andreas, por)
head(san_andreas.por)
head(PoR_to_geographical(san_andreas.por, por))
}
