% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{test_null_theta_ctree}
\alias{test_null_theta_ctree}
\title{Test if a Value Gives a Null Conditional Inference Tree}
\usage{
test_null_theta_ctree(theta, z, data, Trt, Y)
}
\arguments{
\item{theta}{a positive double}

\item{z}{a numeric vector of estimated CATEs from Step 1}

\item{data}{a data frame containing a response, binary treatment indicators,
and covariates.}

\item{Trt}{a string specifying the name of the column of \code{data}
contains the treatment indicators.}

\item{Y}{a string specifying the name of the column of \code{data}
contains the response.}
}
\value{
a boolean. \code{True} if \code{theta} is large enough to give a null
conditional inference tree. \code{False} otherwise.
}
\description{
Fits a conditional inference tree with minimal test statistic \code{theta}
and tests if the tree has more than one terminal node.
}
