% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeVar.R
\name{mergeVar}
\alias{mergeVar}
\title{Combine sample variances from two samples}
\usage{
mergeVar(x.var, y.var, x.mean, y.mean, x.n, y.n)
}
\arguments{
\item{x.var}{sample variance from the first sample, 'x'}

\item{y.var}{sample variance from the second sample, 'y'}

\item{x.mean}{sample mean from the first sample, 'x'}

\item{y.mean}{sample mean from the second sample, 'y'}

\item{x.n}{sample size from the first sample, 'x'}

\item{y.n}{sample size from the second sample, 'y'}
}
\description{
This function combines the sample variance information from two samples (of 
the same phenomena) to return the sample variance of the union of the two 
samples.
}
\details{
This function assumes the data is normalized by n (the MLE estimator) 
instead of n-1 (the unbiased estimator).
}
\references{
Chan, T.F., Golub, G.H., and LeVeque, R.J., 1979, Updating formulae and a pairwise algorithm for computing sample variances: Technical Report, Stanford University .
}
