% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EM_FCtemplateICA.R
\name{EM_FCtemplateICA}
\alias{EM_FCtemplateICA}
\title{EM Template ICA}
\usage{
EM_FCtemplateICA(
  template_mean,
  template_var,
  template_FC,
  prior_params = c(0.001, 0.001),
  BOLD,
  AS_0,
  maxiter = 100,
  miniter = 3,
  epsilon = 0.001,
  Gibbs_nsamp = 1000,
  Gibbs_nburn = 50,
  Gibbs_nchain = 10,
  eps_inter = NULL,
  verbose
)
}
\arguments{
\item{template_mean}{(\eqn{V \times Q} matrix) mean maps for each IC in template,
where \eqn{Q} is the number of ICs, \eqn{V=nvox} is the number of data locations.}

\item{template_var}{(\eqn{V \times Q} matrix) between-subject variance maps for each IC in template}

\item{template_FC}{(list) Parameters of functional connectivity template}

\item{prior_params}{Alpha and beta parameters of IG prior on tau^2 (error variance)}

\item{BOLD}{(\eqn{V \times T} matrix) preprocessed fMRI data}

\item{AS_0}{(list) initial guess at latent variables: A (\eqn{TxQ} mixing matrix),
and S (\eqn{QxV} matrix of spatial ICs)}

\item{maxiter}{Maximum number of EM iterations. Default: \code{100}.}

\item{miniter}{Minimum number of EM iterations. Default: \code{3}.}

\item{epsilon}{Smallest proportion change in log-posterior between iterations.
Default: \code{0.001}.}

\item{Gibbs_nsamp}{the number of Gibbs posterior samples of A and S to output after burn-in}

\item{Gibbs_nburn}{the number of Gibbs posterior samples of A and S to throw away before saving}

\item{Gibbs_nchain}{the number of simultaneous Gibbs chains to run}

\item{eps_inter}{Intermediate values of epsilon at which to save results (used
to assess benefit of more stringent convergence rules). Default:
\code{NULL} (do not save). These values should be in decreasing order
(larger to smaller error) and all values should be between zero and
\code{epsilon}.}

\item{verbose}{If \code{TRUE}, display progress of algorithm. Default: \code{FALSE}.}
}
\value{
A list of computed values, including the final parameter estimates.
}
\description{
EM Algorithm for FC Template ICA Model
}
\details{
\code{EM_FCtemplateICA} implements the expectation-maximization
(EM) algorithm for the functional connectivity (FC) template ICA model
}
\keyword{internal}
