% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seed.R
\name{use_session_with_seed}
\alias{use_session_with_seed}
\title{Use a session with a random seed}
\usage{
use_session_with_seed(
  seed,
  disable_gpu = TRUE,
  disable_parallel_cpu = TRUE,
  quiet = FALSE
)
}
\arguments{
\item{seed}{A single value, interpreted as an integer}

\item{disable_gpu}{\code{TRUE} to disable GPU execution (see \emph{Parallelism} below).}

\item{disable_parallel_cpu}{\code{TRUE} to disable CPU parallelism (see
\emph{Parallelism} below).}

\item{quiet}{\code{TRUE} to suppress printing of messages.}
}
\value{
TensorFlow session object, invisibly
}
\description{
Set various random seeds required to ensure reproducible results. The
provided \code{seed} value will establish a new random seed for R, Python, NumPy,
and TensorFlow. GPU computations and CPU parallelism will also be disabled by
default.
}
\details{
This function must be called at the very top of your script (i.e.
immediately after \code{library(tensorflow)}, \code{library(keras)}, etc.). Any
existing TensorFlow session is torn down via \code{tf$reset_default_graph()}.

This function takes all measures known to promote reproducible results from
TensorFlow sessions, however it's possible that various individual
TensorFlow features or dependent libraries escape its effects. If you
encounter non-reproducible results please investigate the possible sources
of the problem, contributions via pull request are very welcome!

Packages which need to be notified before and after the seed is set
can register for the "tensorflow.on_before_use_session" and
"tensorflow.on_use_session" hooks (see \code{\link[=setHook]{setHook()}}) for additional
details on hooks).
}
\section{Parallelism}{
 By default the \code{use_session_with_seed()} function
disables GPU and CPU parallelism, since both can result in
non-deterministic execution patterns (see
\url{https://stackoverflow.com/questions/42022950/}). You can optionally enable
GPU or CPU parallelism by setting the \code{disable_gpu} and/or
\code{disable_parallel_cpu} parameters to \code{FALSE}.
}

\examples{
\dontrun{
library(tensorflow)
use_session_with_seed(42)
}

}
