% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparse.choosekrl.R
\name{sparse.choosekrl}
\alias{sparse.choosekrl}
\title{Perform tuning parameter (\eqn{d_1}, \eqn{d_2} and \eqn{d_3}) selection for sparse tensor clustering via cross validation}
\usage{
sparse.choosekrl(x, k, r, l, lambda = 0, percent = 0.2,
  trace = FALSE, nstart = 20, sim.times = 1, method = "L0")
}
\arguments{
\item{x}{a three-dimensional array}

\item{k}{the range of \eqn{d_1}: a vector, the possible clusters numbers of mode 1}

\item{r}{the range of \eqn{d_2}: a vector, the possible clusters numbers of mode 2}

\item{l}{the range of \eqn{d_3}: a vector, the possible clusters numbers of mode 3}

\item{lambda}{a numeric value. The coefficient of the regularization term.}

\item{percent}{a numeric value between 0 and 1}

\item{trace}{trace logic value. If true, it would print the iteration situation.}

\item{nstart}{positive interger. The same as the "nstart" in kmeans().}

\item{sim.times}{the same as label2(): the times of calling classify2() with different seeds.}

\item{method}{two options: "L0", "L1". Two methods use different penalties, where "L0" indicating L0 penalty and "L1" indicating Lasso penalty.}
}
\value{
a list   
\code{estimated_krl} a 1*3 matrix which is the estimated c(d_1,d_2,d_3).  

               \code{results.se} the standard error of each possible combination of the cluster numbers.  
               
               \code{results.mean} the mean residual of each possible combination of the cluster numbers.
}
\description{
Select the best \eqn{d_1}, \eqn{d_2} and \eqn{d_3} to perform clustering. A range of values of d[1], d[2], d[3] is usually considered.
}
