% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/like_inference.R
\name{array_bic_aic}
\alias{array_bic_aic}
\title{Calculate the AIC and BIC.}
\usage{
array_bic_aic(sig_squared, p, mode_ident = NULL, mode_diag = NULL,
  mode_unstructured = NULL)
}
\arguments{
\item{sig_squared}{A numeric. The MLE of sigma^2 in the array normal model
(the 'variance' form of the total variation parameter).}

\item{p}{A vector of integers. The dimension of the data array (including
replication modes).}

\item{mode_ident}{A vector of integers. The modes assumed to have identity
covariances.}

\item{mode_diag}{A vector of integers. The modes assumed to have diagional
covariances.}

\item{mode_unstructured}{A vector of integers. The modes of assumed to have
unstructured covariances.}
}
\value{
\code{AIC} A numeric. The AIC of the model.

  \code{BIC} A numeric. The BIC of the model.
}
\description{
Calculate the AIC and BIC for Kronecker structured covariance models,
assuming the array normal distribution.
}
\details{
The AIC and BIC depend only on the data through the MLE of the total
variation parameter. Given this, the dimension of the array, and a
specification of which modes are the identity and which are unstructured,
this function will calculate the AIC and BIC.
}
\examples{
# Generate random array data with first mode having unstructured covariance
#  second having diagonal covariance structure and third mode having identity
#  covariance structure.
set.seed(857)
p <- c(4, 4, 4)
Z <- array(stats::rnorm(prod(p)), dim = p)
Y <- atrans(Z, list(tensr:::rwish(diag(p[1])), diag(1:p[2]), diag(p[3])))

# Use holq() to fit various models.
false_fit1 <- holq(Y, mode_rep = 1:3) ## identity for all modes
false_fit2 <- holq(Y, mode_rep = 2:3) ## unstructured first mode
true_fit <- holq(Y, mode_rep = 3, mode_diag = 2) ## correct model

# Get AIC and BIC values.
false_aic1 <- array_bic_aic(false_fit1$sig ^ 2, p, mode_ident = 1:length(p))
false_aic2 <- array_bic_aic(false_fit2$sig ^ 2, p, mode_ident = 2:length(p),
                            mode_unstructured = 1)
true_aic <- array_bic_aic(true_fit$sig ^ 2, p, mode_ident = 2:length(p), mode_diag = 1)

# Plot the results.
plot(c(false_aic1$AIC, false_aic2$AIC, true_aic$AIC), type = "l",
     xaxt = "n", xlab = "Model", ylab = "AIC", main = "AIC")
axis(side = 1, at = 1:3, labels = c("Wrong Model 1", "Wrong Model 2", "Right Model"))

plot(c(false_aic1$BIC, false_aic2$BIC, true_aic$BIC), type = "l", xaxt = "n",
     xlab = "Model", ylab = "BIC", main = "BIC")
axis(side = 1, at = 1:3, labels = c("Wrong Model 1", "Wrong Model 2", "Right Model"))
}
\author{
David Gerard.
}
\seealso{
\code{\link{holq}} for obtaining \code{sig_squared}.
}
\keyword{likelihood}

