% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_decompositions.R
\name{get_isvd}
\alias{get_isvd}
\title{Calculate the incredible SVD (ISVD).}
\usage{
get_isvd(x_holq)
}
\arguments{
\item{x_holq}{The output from \code{\link{holq}}.}
}
\value{
l A numeric.

U A list of orthogonal matrices.

D A list of diagonal matrices with positive diagonal entries and unit
  determinant. The diagonal entries are in descending order.

V A scaled all-orthonormal array.
}
\description{
The ISVD is a generalization of the SVD to tensors. It is derived from the
incredible HOLQ.
}
\details{
Let \code{sig * atrans(Z, L)} be the HOLQ of \code{X}. Then the ISVD
calculates the SVD of each \code{L[[i]]}, call it \code{U[[i]] \%*\% D[[i]]
\%*\% t(W[[i]])}. It then returns \code{l = sig}, \code{U}, \code{D}, and
\code{V = atrans(Z, W)}. These values have the property that \code{X} is
equal to \code{l * atrans(atrans(V, D), U)}, up to numerical precision.
\code{V} is also scaled all-orthonormal.

For more details on the ISVD, see
\href{http://arxiv.org/abs/1410.1094}{Gerard and Hoff (2014)}.
}
\examples{
#Generate random data.
p <- c(4,4,4)
X <- array(stats::rnorm(prod(p)), dim = p)

#Calculate HOLQ, then ISVD
holq_x <- holq(X)
isvd_x <- get_isvd(holq_x)
l <- isvd_x$l
U <- isvd_x$U
D <- isvd_x$D
V <- isvd_x$V

#Recover X
trim(X - l * atrans(atrans(V, D), U))

#V is scaled all-orthonormal
trim(mat(V, 1) \%*\% t(mat(V, 1)), epsilon = 10^-5)

trim(mat(V, 2) \%*\% t(mat(V, 2)), epsilon = 10^-5)

trim(mat(V, 3) \%*\% t(mat(V, 3)), epsilon = 10^-5)
}
\author{
David Gerard.
}
\references{
Gerard, D. C., & Hoff, P. D. (2014).
  \href{http://arxiv.org/abs/1410.1094}{A higher-order LQ decomposition for
  separable covariance models}. \emph{arXiv preprint arXiv:1410.1094.}
}
\keyword{decompositions}

