% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allauc.R
\name{allauc}
\alias{allauc}
\title{Calculate Area Under Curve (AUC) and Differences of AUC for Transcript Data}
\usage{
allauc(bytranslistmean, expdf, nbwindows, nbcpu = 1,
 controlcondname = "ctrl", stresscondname = "HS", showtime = FALSE,
 verbose = TRUE)
}
\arguments{
\item{bytranslistmean}{A list of data frames, each containing transcript
level data with mean values for one or more
conditions.}

\item{expdf}{A data frame containing experiment data that should have
columns named 'condition', 'replicate', 'strand', and 'path'.}

\item{nbwindows}{An integer specifying the number of windows to consider for
AUC calculations.}

\item{nbcpu}{An integer specifying the number of CPU cores to use for
parallel processing on bytranslistmean. Defaults to \code{1}.}

\item{controlcondname}{A string specifying the name of the control condition
Defaults to \code{"ctrl"}.}

\item{stresscondname}{A string specifying the name of the stress condition.
Defaults to \code{"HS"}.}

\item{showtime}{A logical value indicating if the duration of the function
processing should be indicated before ending. Defaults to
\code{FALSE}.}

\item{verbose}{A logical value indicating whether to print progress messages
Defaults to \code{TRUE}.}
}
\value{
A data frame containing the AUC and dAUC results for each transcript,
        along with associated statistical information.
}
\description{
This function computes the Area Under Curve (AUC) and the differences of AUC
between two conditions for a list of transcript data. It supports parallel
computation for efficiency. If only one condition is given, the differences
are not computed.
}
\details{
The function first checks if exactly two conditions are present in
         `expdf`. If so, it computes the differences in AUC between the two
         conditions using a Kolmogorov-Smirnov test. It then calculates the
         AUC for all conditions against a reference line (y=x). Results are
         merged by transcript and include adjusted p-values.
}
\examples{
exppath <-  system.file("extdata", "exptab.csv", package="tepr")
transpath <- system.file("extdata", "cugusi_6.tsv", package="tepr")
expthres <- 0.1

## Reading tables
expdf <- read.csv(exppath)
transdf <- read.delim(transpath, header = FALSE)

## Computing intermediate steps
avfilt <- averageandfilterexprs(expdf, transdf, expthres,
        showtime = FALSE, verbose = FALSE)
ecdf <- genesECDF(avfilt, verbose = FALSE)
resecdf <- ecdf[[1]]
nbwindows <- ecdf[[2]]
meandiff <- meandifference(resecdf, expdf, nbwindows,
    verbose = FALSE)
bytranslistmean <- split(meandiff, factor(meandiff$transcript))

## Testing allauc
res <- allauc(bytranslistmean, expdf, nbwindows, verbose = FALSE)

}
\seealso{
[genesECDF]
}
