% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_mmrm.R
\name{g_mmrm_lsmeans}
\alias{g_mmrm_lsmeans}
\title{Plot LS means for MMRM}
\usage{
g_mmrm_lsmeans(
  object,
  select = c("estimates", "contrasts"),
  titles = c(estimates = paste("Adjusted mean of", object$labels$response,
    "by treatment at visits"), contrasts = paste0("Differences of ",
    object$labels$response, " adjusted means vs. control ('", object$ref_level, "')")),
  xlab = object$labels$visit,
  ylab = paste0("Estimates with ", round(object$conf_level * 100), "\% CIs"),
  width = 0.6,
  show_pval = TRUE,
  show_lines = FALSE,
  constant_baseline = NULL,
  n_baseline = NA_integer_,
  table_stats = character(),
  table_formats = c(n = "xx.", estimate = "xx.x", se = "xx.x", ci = "(xx.xx, xx.xx)"),
  table_labels = c(n = "n", estimate = "LS mean", se = "Std. Error", ci =
    paste0(round(object$conf_level * 100), "\% CI")),
  table_font_size = 3,
  table_rel_height = 0.5
)
}
\arguments{
\item{object}{(\code{tern_mmrm})\cr model result produced by \code{\link[=fit_mmrm]{fit_mmrm()}}.}

\item{select}{(\code{character})\cr to select one or both of "estimates" and "contrasts" plots.
Note "contrasts" option is not applicable to model summaries excluding an arm variable.}

\item{titles}{(\code{character})\cr with elements \code{estimates} and \code{contrasts} containing the plot titles.}

\item{xlab}{(\code{string})\cr the x axis label.}

\item{ylab}{(\code{string})\cr the y axis label.}

\item{width}{(\code{numeric})\cr width of the error bars.}

\item{show_pval}{(\code{flag})\cr should the p-values for the differences of
LS means vs. control be displayed (not default)?}

\item{show_lines}{(\code{flag})\cr should the visit estimates be connected by lines (not default)?}

\item{constant_baseline}{(named \code{number} or \code{NULL})\cr optional constant baseline for the
LS mean estimates. If specified then needs to be a named \code{number}, and the name will be used to
label the corresponding baseline visit. The differences of LS means will always be 0 at this
baseline visit.}

\item{n_baseline}{(\code{int} or named \code{integer})\cr optional number of patients at baseline.
Since this can be visible in the optional table below the estimates plot, and we cannot
infer this from \code{object} (since that is then only fit without baseline data), we need
to allow the user to specify this. If \code{number} then assumed constant across potential
treatment arms, otherwise one number per treatment arm can be provided.}

\item{table_stats}{(\code{character})\cr names of the statistics that will be displayed in the
table below the estimates plot. Note that the table will only be added when selecting only the
"estimates" plot. Available statistics are \code{n}, \code{estimate}, \code{se}, and \code{ci}.}

\item{table_formats}{(named \code{character})\cr format patterns for descriptive statistics
used in the (optional) estimates table appended to the estimates plot.}

\item{table_labels}{(named \code{character})\cr
labels for the statistics in the (optional) estimates table.}

\item{table_font_size}{(\code{number})\cr
controls the font size of values in the (optional) estimates table.}

\item{table_rel_height}{(\code{number})\cr
controls the relative height of the (optional) estimates table compared to the estimates plot.}
}
\value{
A \code{ggplot2} plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function summarizes adjusted \code{lsmeans} and standard error, as well as conducts
comparisons between groups' adjusted \code{lsmeans}, where the first level of the group
is the reference level.
}
\details{
If variable labels are available in the original data set, then these are used. Otherwise
the variable names themselves are used for annotating the plot.

The contrast plot is not going to be returned if treatment is not
considered in the \code{tern_mmrm} object input,
no matter if \code{select} argument contains the \code{contrasts} value.
}
\examples{
library(dplyr)

mmrm_results <- fit_mmrm(
  vars = list(
    response = "FEV1",
    covariates = c("RACE", "SEX"),
    id = "USUBJID",
    arm = "ARMCD",
    visit = "AVISIT"
  ),
  data = mmrm_test_data,
  cor_struct = "unstructured",
  weights_emmeans = "equal"
)
g_mmrm_lsmeans(mmrm_results, constant_baseline = c(BSL = 0))
g_mmrm_lsmeans(
  mmrm_results,
  select = "estimates",
  show_lines = TRUE,
  xlab = "Visit"
)
g_mmrm_lsmeans(
  mmrm_results,
  select = "contrasts",
  titles = c(contrasts = "Contrasts of FKSI-FWB means"),
  show_pval = TRUE,
  show_lines = TRUE,
  width = 0.8
)

mmrm_test_data2 <- mmrm_test_data \%>\%
  filter(ARMCD == "TRT")

mmrm_results_no_arm <- fit_mmrm(
  vars = list(
    response = "FEV1",
    covariates = c("RACE", "SEX"),
    id = "USUBJID",
    visit = "AVISIT"
  ),
  data = mmrm_test_data2,
  cor_struct = "unstructured",
  weights_emmeans = "equal"
)

g_mmrm_lsmeans(mmrm_results_no_arm, select = "estimates")
g_mmrm_lsmeans(
  mmrm_results_no_arm,
  select = c("estimates", "contrasts"),
  titles = c(
    estimates = "Adjusted mean of FKSI-FWB",
    contrasts = "it will not be created"
  ),
  show_pval = TRUE,
  width = 0.8
)

g_mmrm_lsmeans(
  mmrm_results_no_arm,
  select = "estimates",
  titles = c(estimates = "Adjusted mean of FKSI-FWB"),
  show_pval = TRUE,
  width = 0.8,
  show_lines = TRUE
)

g_mmrm_lsmeans(
  mmrm_results,
  select = "estimates",
  titles = c(estimates = "Adjusted mean of FKSI-FWB"),
  table_stats = c("n", "ci")
)
}
