% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h_stack_by_baskets.R
\name{h_stack_by_baskets}
\alias{h_stack_by_baskets}
\title{Helper Function to create a new \code{SMQ} variable in \code{ADAE} by stacking \code{SMQ} and/or \code{CQ} records.}
\usage{
h_stack_by_baskets(
  df,
  baskets = grep("^(SMQ|CQ).+NAM$", names(df), value = TRUE),
  smq_varlabel = "Standardized MedDRA Query",
  keys = c("STUDYID", "USUBJID", "ASTDTM", "AEDECOD", "AESEQ"),
  aag_summary = NULL,
  na_level = "<Missing>"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{baskets}{(\code{character})\cr variable names of the selected Standardized/Customized queries.}

\item{smq_varlabel}{(\code{string})\cr a label for the new variable created.}

\item{keys}{(\code{character})\cr names of the key variables to be returned along with the new variable created.}

\item{aag_summary}{(\code{data.frame})\cr containing the \code{SMQ} baskets and the levels of interest for the final \code{SMQ}
variable. This is useful when there are some levels of interest that are not observed in the \code{df} dataset.
The two columns of this dataset should be named \code{basket} and \code{basket_name}.}

\item{na_level}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}
}
\value{
\code{data.frame} with variables in \code{keys} taken from \code{df} and new variable \code{SMQ} containing
records belonging to the baskets selected via the \code{baskets} argument.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Helper Function to create a new \code{SMQ} variable in \code{ADAE} that consists of all adverse events belonging to
selected Standardized/Customized queries. The new dataset will only contain records of the adverse events
belonging to any of the selected baskets. Remember that \code{na_level} must match the needed pre-processing
done with \code{\link[=df_explicit_na]{df_explicit_na()}} to have the desired output.
}
\examples{
adae <- tern_ex_adae[1:20, ] \%>\% df_explicit_na()
h_stack_by_baskets(df = adae)

aag <- data.frame(
  NAMVAR = c("CQ01NAM", "CQ02NAM", "SMQ01NAM", "SMQ02NAM"),
  REFNAME = c(
    "D.2.1.5.3/A.1.1.1.1 AESI", "X.9.9.9.9/Y.8.8.8.8 AESI",
    "C.1.1.1.3/B.2.2.3.1 AESI", "C.1.1.1.3/B.3.3.3.3 AESI"
  ),
  SCOPE = c("", "", "BROAD", "BROAD"),
  stringsAsFactors = FALSE
)

basket_name <- character(nrow(aag))
cq_pos <- grep("^(CQ).+NAM$", aag$NAMVAR)
smq_pos <- grep("^(SMQ).+NAM$", aag$NAMVAR)
basket_name[cq_pos] <- aag$REFNAME[cq_pos]
basket_name[smq_pos] <- paste0(
  aag$REFNAME[smq_pos], "(", aag$SCOPE[smq_pos], ")"
)

aag_summary <- data.frame(
  basket = aag$NAMVAR,
  basket_name = basket_name,
  stringsAsFactors = TRUE
)

result <- h_stack_by_baskets(df = adae, aag_summary = aag_summary)
all(levels(aag_summary$basket_name) \%in\% levels(result$SMQ))

h_stack_by_baskets(
  df = adae,
  aag_summary = NULL,
  keys = c("STUDYID", "USUBJID", "AEDECOD", "ARM"),
  baskets = "SMQ01NAM"
)

}
