% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_fraction_fixed_dp}
\alias{format_fraction_fixed_dp}
\title{Formatting Fraction and Percentage with Fixed Single Decimal Place}
\usage{
format_fraction_fixed_dp(x, ...)
}
\arguments{
\item{x}{(\code{integer})\cr with elements \code{num} and \code{denom}.}

\item{...}{required for \code{rtables} interface.}
}
\value{
A string in the format \verb{num / denom (ratio \%)}. If \code{num} is 0, the format is \code{num / denom}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Formats a fraction together with ratio in percent with fixed single decimal place.
Includes trailing zero in case of whole number percentages to always keep one decimal place.
}
\examples{
format_fraction_fixed_dp(x = c(num = 1L, denom = 2L))
format_fraction_fixed_dp(x = c(num = 1L, denom = 4L))
format_fraction_fixed_dp(x = c(num = 0L, denom = 3L))

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_auto}()},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction_lt10}()},
\code{\link{format_count_fraction}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_extreme_values}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_fraction}()},
\code{\link{format_sigfig}()},
\code{\link{format_xx}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
