% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_patients_exposure_in_cols.R
\name{summarize_patients_exposure_in_cols}
\alias{summarize_patients_exposure_in_cols}
\alias{analyze_patients_exposure_in_cols}
\alias{s_count_patients_sum_exposure}
\alias{a_count_patients_sum_exposure}
\title{Count number of patients and sum exposure across all patients in columns}
\usage{
analyze_patients_exposure_in_cols(
  lyt,
  var = NULL,
  ex_var = "AVAL",
  id = "USUBJID",
  add_total_level = FALSE,
  custom_label = NULL,
  col_split = TRUE,
  na_str = default_na_str(),
  .stats = c("n_patients", "sum_exposure"),
  .labels = c(n_patients = "Patients", sum_exposure = "Person time"),
  .indent_mods = 0L,
  ...
)

summarize_patients_exposure_in_cols(
  lyt,
  var,
  ex_var = "AVAL",
  id = "USUBJID",
  add_total_level = FALSE,
  custom_label = NULL,
  col_split = TRUE,
  na_str = default_na_str(),
  ...,
  .stats = c("n_patients", "sum_exposure"),
  .labels = c(n_patients = "Patients", sum_exposure = "Person time"),
  .indent_mods = NULL
)

s_count_patients_sum_exposure(
  df,
  ex_var = "AVAL",
  id = "USUBJID",
  labelstr = "",
  .stats = c("n_patients", "sum_exposure"),
  .N_col,
  custom_label = NULL
)

a_count_patients_sum_exposure(
  df,
  var = NULL,
  ex_var = "AVAL",
  id = "USUBJID",
  add_total_level = FALSE,
  custom_label = NULL,
  labelstr = "",
  .N_col,
  .stats,
  .formats = list(n_patients = "xx (xx.x\%)", sum_exposure = "xx")
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{ex_var}{(\code{string})\cr name of the variable in \code{df} containing exposure values.}

\item{id}{(\code{string})\cr subject variable name.}

\item{add_total_level}{(\code{flag})\cr adds a "total" level after the others which includes all the levels
that constitute the split. A custom label can be set for this level via the \code{custom_label} argument.}

\item{custom_label}{(\code{string} or \code{NULL})\cr if provided and \code{labelstr} is empty, this will be used as label.}

\item{col_split}{(\code{flag})\cr whether the columns should be split. Set to \code{FALSE} when the required
column split has been done already earlier in the layout pipe.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{.stats}{(\code{character})\cr statistics to select for the table. Run
\code{get_stats("analyze_patients_exposure_in_cols")} to see available statistics for this function.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{...}{additional arguments for the lower level functions.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{string})\cr label of the level of the parent split currently being summarized
(must be present as second argument in Content Row Functions). See \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}
for more information.}

\item{.N_col}{(\code{integer(1)})\cr column-wise N (column count) for the full column being analyzed that is typically
passed by \code{rtables}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}
}
\value{
\itemize{
\item \code{analyze_patients_exposure_in_cols()} returns a layout object suitable for passing to further
layouting functions, or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will
add formatted data rows, with the statistics from \code{s_count_patients_sum_exposure()} arranged in
columns, to the table layout.
}

\itemize{
\item \code{summarize_patients_exposure_in_cols()} returns a layout object suitable for passing to further
layouting functions, or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will
add formatted content rows, with the statistics from \code{s_count_patients_sum_exposure()} arranged in
columns, to the table layout.
}

\itemize{
\item \code{s_count_patients_sum_exposure()} returns a named \code{list} with the statistics:
\itemize{
\item \code{n_patients}: Number of unique patients in \code{df}.
\item \code{sum_exposure}: Sum of \code{ex_var} across all patients in \code{df}.
}
}

\itemize{
\item \code{a_count_patients_sum_exposure()} returns formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=analyze_patients_exposure_in_cols]{analyze_patients_exposure_in_cols()}} creates a layout element to count total numbers of
patients and sum an analysis value (i.e. exposure) across all patients in columns.

The primary analysis variable \code{ex_var} is the exposure variable used to calculate the \code{sum_exposure} statistic. The
\code{id} variable is used to uniquely identify patients in the data such that only unique patients are counted in the
\code{n_patients} statistic, and the \code{var} variable is used to create a row split if needed. The percentage returned as
part of the \code{n_patients} statistic is the proportion of all records that correspond to a unique patient.

The summarize function \code{\link[=summarize_patients_exposure_in_cols]{summarize_patients_exposure_in_cols()}} performs the same function as
\code{\link[=analyze_patients_exposure_in_cols]{analyze_patients_exposure_in_cols()}} except it creates content rows, not data rows, to summarize the current table
row/column context and operates on the level of the latest row split or the root of the table if no row splits have
occurred.

If a column split has not yet been performed in the table, \code{col_split} must be set to \code{TRUE} for the first call of
\code{\link[=analyze_patients_exposure_in_cols]{analyze_patients_exposure_in_cols()}} or \code{\link[=summarize_patients_exposure_in_cols]{summarize_patients_exposure_in_cols()}}.
}
\section{Functions}{
\itemize{
\item \code{analyze_patients_exposure_in_cols()}: Layout-creating function which can take statistics
function arguments and additional format arguments. This function is a wrapper for
\code{\link[rtables:split_cols_by_multivar]{rtables::split_cols_by_multivar()}} and \code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}}.

\item \code{summarize_patients_exposure_in_cols()}: Layout-creating function which can take statistics
function arguments and additional format arguments. This function is a wrapper for
\code{\link[rtables:split_cols_by_multivar]{rtables::split_cols_by_multivar()}} and \code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}}.

\item \code{s_count_patients_sum_exposure()}: Statistics function which counts numbers
of patients and the sum of exposure across all patients.

\item \code{a_count_patients_sum_exposure()}: Analysis function which is used as \code{afun} in
\code{\link[rtables:analyze_colvars]{rtables::analyze_colvars()}} within \code{analyze_patients_exposure_in_cols()} and as \code{cfun} in
\code{\link[rtables:summarize_row_groups]{rtables::summarize_row_groups()}} within \code{summarize_patients_exposure_in_cols()}.

}}
\note{
As opposed to \code{\link[=summarize_patients_exposure_in_cols]{summarize_patients_exposure_in_cols()}} which generates content rows,
\code{analyze_patients_exposure_in_cols()} generates data rows which will \emph{not} be repeated on multiple
pages when pagination is used.
}
\examples{
set.seed(1)
df <- data.frame(
  USUBJID = c(paste("id", seq(1, 12), sep = "")),
  ARMCD = c(rep("ARM A", 6), rep("ARM B", 6)),
  SEX = c(rep("Female", 6), rep("Male", 6)),
  AVAL = as.numeric(sample(seq(1, 20), 12)),
  stringsAsFactors = TRUE
)
adsl <- data.frame(
  USUBJID = c(paste("id", seq(1, 12), sep = "")),
  ARMCD = c(rep("ARM A", 2), rep("ARM B", 2)),
  SEX = c(rep("Female", 2), rep("Male", 2)),
  stringsAsFactors = TRUE
)

lyt <- basic_table() \%>\%
  split_cols_by("ARMCD", split_fun = add_overall_level("Total", first = FALSE)) \%>\%
  summarize_patients_exposure_in_cols(var = "AVAL", col_split = TRUE) \%>\%
  analyze_patients_exposure_in_cols(var = "SEX", col_split = FALSE)
result <- build_table(lyt, df = df, alt_counts_df = adsl)
result

lyt2 <- basic_table() \%>\%
  split_cols_by("ARMCD", split_fun = add_overall_level("Total", first = FALSE)) \%>\%
  summarize_patients_exposure_in_cols(
    var = "AVAL", col_split = TRUE,
    .stats = "n_patients", custom_label = "some custom label"
  ) \%>\%
  analyze_patients_exposure_in_cols(var = "SEX", col_split = FALSE, ex_var = "AVAL")
result2 <- build_table(lyt2, df = df, alt_counts_df = adsl)
result2

lyt3 <- basic_table() \%>\%
  analyze_patients_exposure_in_cols(var = "SEX", col_split = TRUE, ex_var = "AVAL")
result3 <- build_table(lyt3, df = df, alt_counts_df = adsl)
result3

# Adding total levels and custom label
lyt4 <- basic_table(
  show_colcounts = TRUE
) \%>\%
  analyze_patients_exposure_in_cols(
    var = "ARMCD",
    col_split = TRUE,
    add_total_level = TRUE,
    custom_label = "TOTAL"
  ) \%>\%
  append_topleft(c("", "Sex"))

result4 <- build_table(lyt4, df = df, alt_counts_df = adsl)
result4

lyt5 <- basic_table() \%>\%
  summarize_patients_exposure_in_cols(var = "AVAL", col_split = TRUE)

result5 <- build_table(lyt5, df = df, alt_counts_df = adsl)
result5

lyt6 <- basic_table() \%>\%
  summarize_patients_exposure_in_cols(var = "AVAL", col_split = TRUE, .stats = "sum_exposure")

result6 <- build_table(lyt6, df = df, alt_counts_df = adsl)
result6

a_count_patients_sum_exposure(
  df = df,
  var = "SEX",
  .N_col = nrow(df),
  .stats = "n_patients"
)

}
\keyword{internal}
