% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abnormal_by_worst_grade_worsen.R
\name{abnormal_by_worst_grade_worsen}
\alias{abnormal_by_worst_grade_worsen}
\alias{count_abnormal_lab_worsen_by_baseline}
\alias{s_count_abnormal_lab_worsen_by_baseline}
\alias{a_count_abnormal_lab_worsen_by_baseline}
\title{Count patients with toxicity grades that have worsened from baseline by highest grade post-baseline}
\usage{
count_abnormal_lab_worsen_by_baseline(
  lyt,
  var,
  variables = list(id = "USUBJID", baseline_var = "BTOXGR", direction_var = "GRADDR"),
  na_str = default_na_str(),
  nested = TRUE,
  ...,
  table_names = NULL,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_count_abnormal_lab_worsen_by_baseline(
  df,
  .var = "ATOXGR",
  variables = list(id = "USUBJID", baseline_var = "BTOXGR", direction_var = "GRADDR")
)

a_count_abnormal_lab_worsen_by_baseline(
  df,
  .var = "ATOXGR",
  variables = list(id = "USUBJID", baseline_var = "BTOXGR", direction_var = "GRADDR")
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables including:
\itemize{
\item \code{id} (\code{string})\cr subject variable name.
\item \code{baseline_var} (\code{string})\cr name of the data column containing baseline toxicity variable.
\item \code{direction_var} (\code{string})\cr see \code{direction_var} for more details.
}}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{...}{additional arguments for the lower level functions.}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \code{'fraction'}}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var, var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}
}
\value{
\itemize{
\item \code{count_abnormal_lab_worsen_by_baseline()} returns a layout object suitable for passing to further layouting
functions, or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted
rows containing the statistics from \code{s_count_abnormal_lab_worsen_by_baseline()} to the table layout.
}

\itemize{
\item \code{s_count_abnormal_lab_worsen_by_baseline()} returns the counts and fraction of patients whose worst
post-baseline lab grades are worse than their baseline grades, for post-baseline worst grades
"1", "2", "3", "4" and "Any".
}

\itemize{
\item \code{a_count_abnormal_lab_worsen_by_baseline()} returns the corresponding list with
formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analyze function \code{\link[=count_abnormal_lab_worsen_by_baseline]{count_abnormal_lab_worsen_by_baseline()}} creates a layout element to count patients with
analysis toxicity grades which have worsened from baseline, categorized by highest (worst) grade post-baseline.

This function analyzes primary analysis variable \code{var} which indicates analysis toxicity grades. Additional
analysis variables that can be supplied as a list via the \code{variables} parameter are \code{id} (defaults to \code{USUBJID}),
a variable to indicate unique subject identifiers, \code{baseline_var} (defaults to \code{BTOXGR}), a variable to indicate
baseline toxicity grades, and \code{direction_var} (defaults to \code{GRADDIR}), a variable to indicate toxicity grade
directions of interest to include (e.g. \code{"H"} (high), \code{"L"} (low), or \code{"B"} (both)).

For the direction(s) specified in \code{direction_var}, patient counts by worst grade for patients who have
worsened from baseline are calculated as follows:
\itemize{
\item \code{1} to \code{4}: The number of patients who have worsened from their baseline grades with worst
grades 1-4, respectively.
\item \code{Any}: The total number of patients who have worsened from their baseline grades.
}

Fractions are calculated by dividing the above counts by the number of patients who's analysis toxicity grades
have worsened from baseline toxicity grades during treatment.

Prior to using this function in your table layout you must use \code{\link[rtables:split_rows_by]{rtables::split_rows_by()}} to create a row
split on variable \code{direction_var}.
}
\section{Functions}{
\itemize{
\item \code{count_abnormal_lab_worsen_by_baseline()}: Layout-creating function which can take statistics function
arguments and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_count_abnormal_lab_worsen_by_baseline()}: Statistics function for patients whose worst post-baseline
lab grades are worse than their baseline grades.

\item \code{a_count_abnormal_lab_worsen_by_baseline()}: Formatted analysis function which is used as \code{afun}
in \code{count_abnormal_lab_worsen_by_baseline()}.

}}
\examples{
library(dplyr)

# The direction variable, GRADDR, is based on metadata
adlb <- tern_ex_adlb \%>\%
  mutate(
    GRADDR = case_when(
      PARAMCD == "ALT" ~ "B",
      PARAMCD == "CRP" ~ "L",
      PARAMCD == "IGA" ~ "H"
    )
  ) \%>\%
  filter(SAFFL == "Y" & ONTRTFL == "Y" & GRADDR != "")

df <- h_adlb_worsen(
  adlb,
  worst_flag_low = c("WGRLOFL" = "Y"),
  worst_flag_high = c("WGRHIFL" = "Y"),
  direction_var = "GRADDR"
)

basic_table() \%>\%
  split_cols_by("ARMCD") \%>\%
  add_colcounts() \%>\%
  split_rows_by("PARAMCD") \%>\%
  split_rows_by("GRADDR") \%>\%
  count_abnormal_lab_worsen_by_baseline(
    var = "ATOXGR",
    variables = list(
      id = "USUBJID",
      baseline_var = "BTOXGR",
      direction_var = "GRADDR"
    )
  ) \%>\%
  append_topleft("Direction of Abnormality") \%>\%
  build_table(df = df, alt_counts_df = tern_ex_adsl)

}
\seealso{
Relevant helper functions \code{\link[=h_adlb_worsen]{h_adlb_worsen()}} and \code{\link[=h_worsen_counter]{h_worsen_counter()}} which are used within
\code{\link[=s_count_abnormal_lab_worsen_by_baseline]{s_count_abnormal_lab_worsen_by_baseline()}} to process input data.
}
\keyword{internal}
