% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test2norm.R
\name{test2norm}
\alias{test2norm}
\title{Convert raw neuropsychological test scores to demographically adjusted norms.}
\usage{
test2norm(
  data = NULL,
  test = NULL,
  test.min = NULL,
  test.max = NULL,
  test.better = c("High", "Low"),
  group.id = NULL,
  control.id = NULL,
  all.controls = FALSE,
  demographics = NULL,
  mfp.alpha = 1,
  rnd.s = TRUE,
  rnd.a = TRUE,
  mean.a = 50,
  sd.a = 10
)
}
\arguments{
\item{data}{a data frame containing the variables needed for the norming
process}

\item{test}{a character string specifying the name of the test to be normed}

\item{test.min}{a real number indicating the smallest possible test score}

\item{test.max}{a real number indicating the largest possible test score}

\item{test.better}{a character string indicating direction of the scores.
Use "High" if high test scores imply better performance, use "Low" otherwise.}

\item{group.id}{a character string specifying the name of the variable
containing group identification (i.e. control vs exposed/test/risk). Ignored,
if all.controls = TRUE.}

\item{control.id}{a character string specifying the label of the control
group within group.id variable. Ignored, if all.controls = TRUE.}

\item{all.controls}{a logical indicating whether all observations should be
treated as controls. Overwrites group.id and control.id.}

\item{demographics}{a single or multiple character strings (concatenated by
c() function) specifying the names of demographic predictors to be included
into normative formulas.}

\item{mfp.alpha}{a numeric value between 0 and 1 that sets significance level
for inclusion of demographic predictors into normative formula. Passed to the
mfp() function. Default value is 1 for inclusion of all predictors
regardless of their significance.}

\item{rnd.s}{a logical indicating whether the scaled scores should be
rounded. Default is TRUE.}

\item{rnd.a}{a logical indicating whether the adjusted scores (T-scores)
should be rounded. Default is TRUE.}

\item{mean.a}{numeric value for the mean of adjusted score (T-score)
distribution.}

\item{sd.a}{numeric value for the standard deviation of adjusted score
(T-score) distribution.}
}
\value{
A list consisting of 6 objects. The first four are vectors containing the
original raw test scores and the calculated scaled scores, demographically
adjusted scores, and deficit scores. The fifth object in the list, called
\code{SS.maps}, contains conversions from raw scores to scaled scores in a
form of a table with two columns, one representing scaled scores (one per
row) and one representing raw scores (range of raw values corresponding to
each scaled score). The last item in the output list is also a list called
\code{MFP.formulas} and contains the information for calculation of adjusted
scores, including variable transformations (if any), multiple fractional
polynomial (MFP) model coefficients, and the standard deviation of residuals
resulting from the MFP modeling.
}
\description{
Convert raw neuropsychological test scores to demographically adjusted norms.
}
\details{
The \code{test2norm()} function can be used by neuropsychologists, who wish
to construct normative formulas for cognitive tests that adjust for expected
effects of demographic characteristics (e.g., age), using methods described
in Heaton et al. (2003 & 2009). The norming procedure makes use of the
\code{mfp()} function from the \code{mfp} package to explore nonlinear
associations between cognition and demographic variables. The raw test scores
that have many decimal digits should be rounded to fewer digits prior to the
application of the \code{test2norm()} function. This will significantly
reduce software running time. The recommended number of decimal digits is 4
or fewer. Detailed description of the procedure will be found in Umlauf et al
(2019).
}
\examples{
data(PsychTestData)
test2norm(data = PsychTestData, test = "rawscore",
          test.min = 0, test.max = 36, test.better = "High",
          group.id = "group", control.id = "control",
          demographics = c("age", "sex"))
}
\references{
Umlauf A et al (2019) Automated procedure to produce normative correction
formulas modeling demographic effects on cognitive test scores and apply them
to obtain demographically corrected scores. Manuscript submitted for
publication.

Heaton RK, Taylor MJ, & Manly J (2003) Demographic effects and use of
demographically corrected norms with the WAIS-III and WMS-III. In: Tulsky D
et al. (Eds.) \emph{Clinical Interpretation of the WAIS-III and WMS-III}.
San Diego, CA: Academic Press, 183-210.

Heaton RK, Ryan L, & Grant I (2009) Demographic influences and use of
demographically corrected norms in neuropsychological assessment. In Grant I
& Adams KM (Eds.) \emph{Neuropsychological Assessment of Neuropsychiatric
and Neuromedical Disorders}. New York, NY: Oxford University Press, 127-155.

Benner A (2005) mfp: Multivariable fractional polynomials.
\emph{R News} 5(2): 20–23.
}
\author{
Anya Umlauf
}
