% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymptoticMemoryComplexityClass.R
\name{asymptoticMemoryComplexityClass}
\alias{asymptoticMemoryComplexityClass}
\title{Asymptotic Memory Complexity Classifying function}
\usage{
asymptoticMemoryComplexityClass(model.df)
}
\arguments{
\item{model.df}{A data frame composed of columns 'Memory usage' and 'Data sizes', which can be obtained by asymptoticMemoryUsage()}
}
\value{
A string specifying the resultant complexity class. (Eg: 'Linear', 'Log-linear', 'Quadratic')
}
\description{
Function to classify the memory complexity of the expression passed onto asymptoticMemoryUsage (which outputs a data frame to be used here)
}
\details{
For more information regarding its implementation or functionality/usage, please check https://anirban166.github.io//Complexity-classifiers/
}
\examples{
# Allocating a square matrix of N*N dimensions against a set of increasing input data sizes:
input.sizes = 10^seq(1, 3, by = 0.1)
memory.usage.data <- asymptoticMemoryUsage(matrix(data = N:N, nrow = N, ncol = N), input.sizes)
# Computing its memory complexity class based on the benchmarked data obtained above:
asymptoticMemoryComplexityClass(memory.usage.data)
# For allocating a square matrix, the quadratic space/memory complexity class is expected.
}
