% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-known.R
\name{expect_known_output}
\alias{expect_known_output}
\alias{expect_output_file}
\alias{expect_known_value}
\alias{expect_equal_to_reference}
\alias{expect_known_hash}
\title{Expectations: is the output or the value equal to a known good value?}
\usage{
expect_known_output(object, file, update = TRUE, ..., info = NULL,
  label = NULL, print = FALSE, width = 80)

expect_known_value(object, file, update = TRUE, ..., info = NULL,
  label = NULL)

expect_known_hash(object, hash = NULL)
}
\arguments{
\item{object}{object to test}

\item{file}{File path where known value/output will be stored.}

\item{update}{Should the file be updated? Defaults to \code{TRUE}, with
the expectation that you'll notice changes because of the first failure,
and then see the modified files in git.}

\item{...}{other values passed to \code{\link[=all.equal]{all.equal()}}}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}

\item{print}{If \code{TRUE} and the result of evaluating \code{code} is
visible this will print the result, ensuring that the output of printing
the object is included in the overall output}

\item{width}{Number of characters per line of output}

\item{hash}{Known hash value. Leave empty and you'll be informed what
to use in the test output.}
}
\description{
For complex printed output and objects, it is often challenging to describe
exactly what you expect to see. \code{expect_known_value()} and
\code{expect_known_output()} provide a slightly weaker guarantee, simply
asserting that the values have no changed since the last time that you ran
them.
}
\details{
These expectations should be used in conjunction with git, as otherwise
there is no way to revert to previous values. Git is particularly useful
in conjunction with \code{expect_known_output()} as the diffs will show you
exactly what has changed.

Note that known values updates will only updated when running tests
interactively. \code{R CMD check} clones the package source so any changes to
the reference files will occured a temporary directory, and will not be
synchronised back to the source package.
}
\examples{
tmp <- tempfile()

# The first run always succeeds
expect_known_output(mtcars[1:10, ], tmp, print = TRUE)

# Subsequent runs will suceed only if the file is unchanged
# This will succeed:
expect_known_output(mtcars[1:10, ], tmp, print = TRUE)

\dontrun{
# This will fail
expect_known_output(mtcars[1:9, ], tmp, print = TRUE)
}
}
