% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_1_textSimilarity.R
\name{textSimilarity}
\alias{textSimilarity}
\title{Compute the semantic similarity between two text variables.}
\usage{
textSimilarity(x, y, method = "cosine", center = TRUE, scale = FALSE)
}
\arguments{
\item{x}{Word embeddings from textEmbed.}

\item{y}{Word embeddings from textEmbed.}

\item{method}{(character) Character string describing type of measure to be computed. Default is "cosine" (see also
"spearmen", "pearson" as well as measures from textDistance() (which here is computed as 1 - textDistance)
including "euclidean", "maximum", "manhattan", "canberra", "binary" and "minkowski").}

\item{center}{(boolean; from base::scale) If center is TRUE then centering is done by subtracting the column means
(omitting NAs) of x from their corresponding columns, and if center is FALSE, no centering is done.}

\item{scale}{(boolean; from base::scale) If scale is TRUE then scaling is done by dividing the (centered)
columns of x by their standard deviations if center is TRUE, and the root mean square otherwise.}
}
\value{
A vector comprising semantic similarity scores. The closer the value is to 1 when using the default
 method, "cosine", the higher the semantic similarity.
}
\description{
Compute the semantic similarity between two text variables.
}
\examples{
# Compute the semantic similarity between the embeddings from "harmonytext" and "satisfactiontext".
\dontrun{
similarity_scores <- textSimilarity(
  x = word_embeddings_4$texts$harmonytext,
  y = word_embeddings_4$texts$satisfactiontext
)

# Show information about how similarity_scores were constructed.
comment(similarity_scores)
}
}
\seealso{
See \code{\link{textDistance}} and \code{\link{textSimilarityNorm}}.
}
