% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgsub.R
\name{fgsub}
\alias{fgsub}
\title{Replace a Regex with an Functional Operation on the Regex Match}
\usage{
fgsub(x, pattern, fun, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string to be matched in the given character vector.}

\item{fun}{A function to operate on the extracted matches.}

\item{\ldots}{ignored.}
}
\value{
Returns a vector with the pattern replaced.
}
\description{
This is a stripped down version of \code{gsubfn} from the \pkg{gsubfn} 
package.  It finds a regex match, and then uses a function to operate on
these matches and uses them to replace the original matches.  Note that
the \pkg{stringi} packages is used for matching and extracting the regex 
matches.  For more powerful needs please see the \pkg{gsubfn} package.
}
\examples{
fgsub(
    x = c(NA, 'df dft sdf', 'sd fdggg sd dfhhh d', 'ddd'),
    pattern = "\\\\b\\\\w*([a-z])(\\\\1{2,})\\\\w*\\\\b",
    fun = function(x) {paste0('<<', paste(rev(strsplit(x, '')[[1]]), collapse =''), '>>')}    
)
}
\seealso{
\code{\link[gsubfn]{gsubfn}}
}
