% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_dependencies.R
\name{textplot_dependencyparser}
\alias{textplot_dependencyparser}
\alias{textplot_dependencyparser.default}
\title{Plot output of a dependency parser}
\usage{
textplot_dependencyparser(x, ...)

\method{textplot_dependencyparser}{default}(
  x,
  title = "Dependency Parser",
  subtitle = "tokenisation, parts of speech tagging & dependency relations",
  vertex_color = "darkgreen",
  edge_color = "red",
  size = 3,
  base_family = "",
  ...
)
}
\arguments{
\item{x}{a data.frame as returned by a call to \code{\link[udpipe]{udpipe}} containing 1 sentence}

\item{...}{not used yet}

\item{title}{character string with the title to use in the plot}

\item{subtitle}{character string with the title to use in the plot}

\item{vertex_color}{character with the color of the label of each node. Defaults to darkgreen.}

\item{edge_color}{character with the color of the edges between the nodes. Defaults to red.}

\item{size}{size of the labels in the plot. Defaults to 3.}

\item{base_family}{character passed on to \code{theme_void} setting the base font family}
}
\value{
an object of class ggplot
}
\description{
Plot output of a dependency parser.
This plot takes one sentence and shows for the sentence,
the words, the parts of speech tag and the dependency relationship between the words.
}
\examples{
\dontshow{
if(require(udpipe) && require(ggraph) && require(ggplot2) && require(igraph))
\{
}
library(udpipe)
library(ggraph)
library(ggplot2)
library(igraph)
\donttest{
x <- udpipe("The economy is weak but the outlook is bright", "english")
textplot_dependencyparser(x)

x <- udpipe("His speech about marshmallows in New York is utter bullshit", "english")
textplot_dependencyparser(x, size = 4)

x <- udpipe("UDPipe provides tokenization, tagging, lemmatization and
             dependency parsing of raw text", "english")
textplot_dependencyparser(x, size = 4)
}

data("example_udpipe", package = "textplot")
textplot_dependencyparser(example_udpipe, size = 4)

\dontshow{
\}
# End of main if statement running only if the required packages are installed
}
}
\seealso{
\code{\link[udpipe]{udpipe}}
}
