% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detvar.R
\name{CalendarVar}
\alias{CalendarVar}
\title{Calendar variables}
\usage{
CalendarVar(x, form = c("dif", "lom", "td"), easter = FALSE, n.ahead = 0)
}
\arguments{
\item{x}{an object of class \code{ts} used to determine the sample period and
frequency.}

\item{form}{a character indicated the set of calendar variables.}

\item{easter}{logical. If TRUE an additional deterministic variable is
generated to capture Easter effects.}

\item{n.ahead}{number of additional observations to extend the sample period.}
}
\value{
A matrix of explanatory variables.
}
\description{
\code{CalendarVar} creates a set of deterministic variables to capture
calendar effects.
}
\examples{

Y <- rsales
X <- CalendarVar(Y, easter = TRUE)

}
\references{
Bell, W.R. and Hillmer, S.C. (1983) “Modeling time series with calendar
variation”, Journal of the American Statistical Society, Vol. 78, pp.
526–534.
}
