% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_batch}
\alias{dataset_batch}
\title{Combines consecutive elements of this dataset into batches.}
\usage{
dataset_batch(dataset, batch_size, drop_remainder = FALSE)
}
\arguments{
\item{dataset}{A dataset}

\item{batch_size}{An integer, representing the number of consecutive elements
of this dataset to combine in a single batch.}

\item{drop_remainder}{Ensure that batches have a fixed size by
omitting any final smaller batch if it's present. Note that this is
required for use with the Keras tensor inputs to fit/evaluate/etc.}
}
\value{
A dataset
}
\description{
Combines consecutive elements of this dataset into batches.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_map}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch_to_device}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
