% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_custom_estimator.R
\name{estimator_spec}
\alias{estimator_spec}
\title{Define an Estimator Specification}
\usage{
estimator_spec(
  mode,
  predictions = NULL,
  loss = NULL,
  train_op = NULL,
  eval_metric_ops = NULL,
  training_hooks = NULL,
  evaluation_hooks = NULL,
  prediction_hooks = NULL,
  training_chief_hooks = NULL,
  ...
)
}
\arguments{
\item{mode}{A key that specifies whether we are performing
training (\code{"train"}), evaluation (\code{"eval"}), or prediction (\code{"infer"}).
These values can also be accessed through the \code{\link[=mode_keys]{mode_keys()}} object.}

\item{predictions}{The prediction tensor(s).}

\item{loss}{The training loss tensor. Must be either scalar, or with shape \code{c(1)}.}

\item{train_op}{The training operation -- typically, a call to \code{optimizer$minimize(...)},
depending on the type of optimizer used during training.}

\item{eval_metric_ops}{A list of metrics to be computed as part of evaluation.
This should be a named list, mapping metric names (e.g. \code{"rmse"}) to the operation
that computes the associated metric (e.g. \code{tf$metrics$root_mean_squared_error(...)}).
These metric operations should be evaluated without any impact on state (typically
is a pure computation results based on variables). For example, it should not
trigger the update ops or requires any input fetching.}

\item{training_hooks}{(Available since TensorFlow v1.4) A list of session run hooks to run on all workers during training.}

\item{evaluation_hooks}{(Available since TensorFlow v1.4) A list of session run hooks to run during evaluation.}

\item{prediction_hooks}{(Available since TensorFlow v1.7) A list of session run hooks to run during prediciton.}

\item{training_chief_hooks}{(Available since TensorFlow v1.4) A list of session run hooks to run on chief worker during training.}

\item{...}{Other optional (named) arguments, to be passed to the \code{EstimatorSpec} constructor.}
}
\description{
Define the estimator specification, used as part of the \code{model_fn} defined with
custom estimators created by \code{\link[=estimator]{estimator()}}. See \code{\link[=estimator]{estimator()}} for more details.
}
\seealso{
Other custom estimator methods: 
\code{\link{estimator}()},
\code{\link{evaluate.tf_estimator}()},
\code{\link{export_savedmodel.tf_estimator}()},
\code{\link{predict.tf_estimator}()},
\code{\link{train.tf_estimator}()}
}
\concept{custom estimator methods}
