% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram.R
\name{summary_histogram}
\alias{summary_histogram}
\alias{summary_histogram.numeric}
\alias{summary_histogram.array}
\title{Creates an histogram summary}
\usage{
summary_histogram(data, ..., metadata = NULL, tag = NA)

\method{summary_histogram}{numeric}(data, ..., metadata = NULL, tag = NA, buckets = 30)

\method{summary_histogram}{array}(data, ..., metadata = NULL, tag = NA, buckets = 30)
}
\arguments{
\item{data}{A Tensor of any shape. The histogram is computed over its elements,
which must be castable to float64.}

\item{...}{Currently unused. To allow future expansion.}

\item{metadata}{A \code{metadata} object, as created with \code{\link[=summary_metadata]{summary_metadata()}}. In
most cases you don't need to change the default.}

\item{tag}{A tag that within the TensorBoard UI. See \code{\link[=log_event]{log_event()}} for other
ways of specifying the tag attribute.}

\item{buckets}{Optional positive int. The output will have this many buckets,
except in two edge cases. If there is no data, then there are no buckets.
If there is data but all points have the same value, then all buckets' left
and right endpoints are the same and only the last bucket has nonzero count.
Defaults to 30 if not specified.}
}
\value{
An histogram summary that can be logged with \code{\link[=log_event]{log_event()}}.
}
\description{
Writes an histogram for later analysis in TensorBoard's Histograms and
Distributions tab.
}
\section{Methods (by class)}{
\itemize{
\item \code{summary_histogram(numeric)}: Creates an histogram summary for a numeric vector.

\item \code{summary_histogram(array)}: Creates an histogram for array data.

}}
\examples{
temp <- tempfile()
with_logdir(temp, {
  for(i in 1:10) {
    log_event(x = summary_histogram(rnorm(10000)))
  }
})

}
\seealso{
Other summary: 
\code{\link{summary_audio}()},
\code{\link{summary_image}()},
\code{\link{summary_scalar}()},
\code{\link{summary_text}()}
}
\concept{summary}
