% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hparams.R
\name{log_hparams}
\alias{log_hparams}
\alias{summary_hparams}
\title{Log hyperaparameters}
\usage{
log_hparams(..., trial_id = NA, time_created_secs = get_wall_time())

summary_hparams(..., trial_id = NA, time_created_secs = get_wall_time())
}
\arguments{
\item{...}{Named values of hyperparameters.}

\item{trial_id}{A name for the current trail. by default it's the hash of the
hparams names and values.}

\item{time_created_secs}{The time the experiment is created in seconds
since the UNIX epoch.}
}
\value{
A hyperparameter summary. USed for the side effects of logging the
hyperparameter to the logdir.
}
\description{
Log hyperaparameters
}
\details{
This function should only be called once in a logdir and it will
record the set of hyperparameters used in that run. Undefined behavior can
happen if it's called more than once in a logdir - specially how TensorBoard
behaves during visualization.
}
\section{Functions}{
\itemize{
\item \code{summary_hparams()}: For advanced users only. It's recommended to use the \code{log_hparams()}
function instead. Creates a hyperparameter summary that can be written with \code{log_event()}.

}}
\examples{
temp <- tempfile()
with_logdir(temp, {
  log_hparams(optimizer = "adam", num_units = 16)
})
}
\seealso{
\code{\link[=log_hparams_config]{log_hparams_config()}}
}
