% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-kernels.R
\name{mcmc_hamiltonian_monte_carlo}
\alias{mcmc_hamiltonian_monte_carlo}
\title{Runs one step of Hamiltonian Monte Carlo.}
\usage{
mcmc_hamiltonian_monte_carlo(
  target_log_prob_fn,
  step_size,
  num_leapfrog_steps,
  state_gradients_are_stopped = FALSE,
  step_size_update_fn = NULL,
  seed = NULL,
  store_parameters_in_results = FALSE,
  name = NULL
)
}
\arguments{
\item{target_log_prob_fn}{Function which takes an argument like
\code{current_state} (if it's a list \code{current_state} will be unpacked) and returns its
(possibly unnormalized) log-density under the target distribution.}

\item{step_size}{\code{Tensor} or \code{list} of \code{Tensor}s representing the step
size for the leapfrog integrator. Must broadcast with the shape of
\code{current_state}. Larger step sizes lead to faster progress, but
too-large step sizes make rejection exponentially more likely. When
possible, it's often helpful to match per-variable step sizes to the
standard deviations of the target distribution in each variable.}

\item{num_leapfrog_steps}{Integer number of steps to run the leapfrog integrator
for. Total progress per HMC step is roughly proportional to
\code{step_size * num_leapfrog_steps}.}

\item{state_gradients_are_stopped}{\code{logical} indicating that the proposed
new state be run through \code{tf$stop_gradient}. This is particularly useful
when combining optimization over samples from the HMC chain.
Default value: \code{FALSE} (i.e., do not apply \code{stop_gradient}).}

\item{step_size_update_fn}{Function taking current \code{step_size}
(typically a \code{tf$Variable}) and \code{kernel_results} (typically
\code{collections$namedtuple}) and returns updated step_size (\code{Tensor}s).
Default value: \code{NULL} (i.e., do not update \code{step_size} automatically).}

\item{seed}{integer to seed the random number generator.}

\item{store_parameters_in_results}{If \code{TRUE}, then \code{step_size} and
\code{num_leapfrog_steps} are written to and read from eponymous fields in
the kernel results objects returned from \code{one_step} and
\code{bootstrap_results}. This allows wrapper kernels to adjust those
parameters on the fly. This is incompatible with \code{step_size_update_fn},
which must be set to \code{NULL}.}

\item{name}{string prefixed to Ops created by this function.
Default value: \code{NULL} (i.e., 'hmc_kernel').}
}
\value{
a Monte Carlo sampling kernel
}
\description{
Hamiltonian Monte Carlo (HMC) is a Markov chain Monte Carlo (MCMC) algorithm
that takes a series of gradient-informed steps to produce a Metropolis
proposal. This class implements one random HMC step from a given
\code{current_state}. Mathematical details and derivations can be found in
Neal (2011).
}
\details{
The \code{one_step} function can update multiple chains in parallel. It assumes
that all leftmost dimensions of \code{current_state} index independent chain states
(and are therefore updated independently). The output of
\code{target_log_prob_fn(current_state)} should sum log-probabilities across all
event dimensions. Slices along the rightmost dimensions may have different
target distributions; for example, \verb{current_state[0, :]} could have a
different target distribution from \verb{current_state[1, :]}. These semantics are
governed by \code{target_log_prob_fn(current_state)}. (The number of independent
chains is \code{tf$size(target_log_prob_fn(current_state))}.)
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1206.1901}{Radford Neal. MCMC Using Hamiltonian Dynamics. \emph{Handbook of Markov Chain Monte Carlo}, 2011.}
\item \href{https://www.jstor.org/stable/120120?seq=1}{Bernard Delyon, Marc Lavielle, Eric, Moulines. \emph{Convergence of a stochastic approximation version of the EM algorithm}, Ann. Statist. 27 (1999), no. 1, 94--128.}
}
}

\seealso{
Other mcmc_kernels: 
\code{\link{mcmc_dual_averaging_step_size_adaptation}()},
\code{\link{mcmc_metropolis_adjusted_langevin_algorithm}()},
\code{\link{mcmc_metropolis_hastings}()},
\code{\link{mcmc_no_u_turn_sampler}()},
\code{\link{mcmc_random_walk_metropolis}()},
\code{\link{mcmc_replica_exchange_mc}()},
\code{\link{mcmc_simple_step_size_adaptation}()},
\code{\link{mcmc_slice_sampler}()},
\code{\link{mcmc_transformed_transition_kernel}()},
\code{\link{mcmc_uncalibrated_hamiltonian_monte_carlo}()},
\code{\link{mcmc_uncalibrated_langevin}()},
\code{\link{mcmc_uncalibrated_random_walk}()}
}
\concept{mcmc_kernels}
