% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_non_I_set.R
\name{calc_non_I_set}
\alias{calc_non_I_set}
\title{Calculates the set I(G) described in Metodiev et al. (2025)
as well as the limit on the complexity of the THAMES associated with it.}
\usage{
calc_non_I_set(scaling, G, sims, c_opt)
}
\arguments{
\item{scaling}{list of fit determined via QDA (means and covariances)}

\item{G}{number of components}

\item{sims}{n_simul x G x (u+1) array of parameters sampled from
the posterior, where
  n_simul is the number of simulations from the posterior,
  G       is the number of components,
  u       is the number of mixture component parameters
          (parameter u+1 is the mixture weight)}

\item{c_opt}{radius of the ellipsoid E from Metodiev et al. (2025)}
}
\value{
a named list with the following elements:
         graph:                  the overlap graph for G
         non_I_set:              the complement of the set I(G)
         complexity_limit_estim: an upper bound on the THAMES complexity
         graphmat:               adjacency matrix of the overlap graph for G
}
\description{
Calculates the set I(G) described in Metodiev et al. (2025)
as well as the limit on the complexity of the THAMES associated with it.
}
\references{
Martin Metodiev, Nicholas J. Irons, Marie Perrot-Dockès,
Pierre Latouche, Adrian E. Raftery. "Easily Computed Marginal Likelihoods
for Multivariate Mixture Models Using the THAMES Estimator."
arXiv preprint arXiv:2504.21812.
}
\keyword{internal}
