% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sounding_wind.R
\name{sounding_wind}
\alias{sounding_wind}
\title{Plot vertical wind speed profile}
\usage{
sounding_wind(pressure, ws, ptop = 100, yaxs = TRUE, ...)
}
\arguments{
\item{pressure}{pressure [hPa]}

\item{ws}{wind speed [knots]}

\item{ptop}{pressure top level [hPa] to be used for plotting wind speed. Valid options should be < 200 hPa (100 by default)}

\item{yaxs}{logic. Whether to add labels to heights on Y lab}

\item{...}{extra graphic arguments}
}
\value{
graphical representation of vertical wind speed profile
}
\description{
Function for plotting wind speed profile. 
Can be launched as standalone function or coupled with pre-drawn Skew-T diagram.
}
\examples{
# load examplary dataset:
data("sounding_vienna")
attach(sounding_vienna)
sounding_wind(pressure = pressure, ws = ws, yaxs = TRUE)
}
