% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/periodicity.R
\name{as_period}
\alias{as_period}
\title{Change \code{tbl_time} periodicity}
\usage{
as_period(x, period = "yearly", side = "start")
}
\arguments{
\item{x}{A \code{tbl_time} object.}

\item{period}{The period to convert to. By default, yearly.}

\item{side}{Whether to return the date at the beginning or the end of the
new period. By default, the \code{"start"} of the period. Use \code{"end"} to change
to the end of the period.}
}
\description{
Convert a \code{tbl_time} object from daily to monthly,
from minute data to hourly, and more. This allows the user to easily
aggregate data to a less granular level.
}
\details{
This function respects \code{\link[dplyr:group_by]{dplyr::group_by()}} groups.

Currently periods finer than second data are not supported.

The \code{side} argument is useful when you want to return data at, say, the
end of a quarter, or the end of a month.
}
\note{
The following periods are available:
\itemize{
\item \code{"yearly"}
\item \code{"quarterly"}
\item \code{"monthly"}
\item \code{"weekly"}
\item \code{"daily"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
}
}
\examples{

# Basic usage ---------------------------------------------------------------

# FB stock prices
data(FB)
FB <- as_tbl_time(FB, date)

# Aggregate FB to yearly data
as_period(FB, "yearly")

# Aggregate FB to yearly data, but use the last data point available
# in that period
as_period(FB, "yearly", "end")

# Aggregate to weekly. Notice that it only uses the earliest day available
# in the data set at that periodicity. It will not set the date of the first
# row to 2013-01-01 because that date did not exist in the original data set.
as_period(FB, "weekly")

# FB is daily data, aggregate to minute?
# Does nothing and returns the original data set.
as_period(FB, "minute")

# Grouped usage -------------------------------------------------------------

# FANG contains Facebook, Amazon, Netflix and Google stock prices
data(FANG)
FANG <- as_tbl_time(FANG, date)

FANG <- FANG \%>\% group_by(symbol)

# Respects groups
FANG \%>\% as_period("yearly")

}
