% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcols.R
\name{lcols}
\alias{lcols}
\title{Create list parser specification}
\usage{
lcols(..., .default = zap())
}
\arguments{
\item{...}{Column specification objects created by \verb{lcol_*()}.}

\item{.default}{Deprecated.}
}
\description{
Create list parser specification
}
\examples{
lcols(
  id = lcol_int("id"),
  name = lcol_chr("name"),
  aliases = lcol_lst_of("aliases", character())
)

# To create multiple columns of the same type use the bang-bang-bang (!!!)
# operator together with `purrr::map()`
int_cols <- purrr::set_names(c("id", "age"))
chr_cols <- purrr::set_names(c("name", "title"))

lcols(
  !!!purrr::map(int_cols, lcol_int),
  !!!purrr::map(chr_cols, lcol_chr)
)
}
