% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.tidyLPA.r
\name{as.tidyLPA}
\alias{as.tidyLPA}
\title{Convert Mplus output to object of class 'tidyLPA'}
\usage{
as.tidyLPA(modelList)
}
\arguments{
\item{modelList}{A list of class \code{modelList}, as generated by
\code{\link[MplusAutomation]{readModels}}.}
}
\value{
A list of class  \code{tidyLPA}.
}
\description{
Takes a list of Mplus output files of class \code{modelList},
containing only mixture models with a single categorical latent variable, and
converts it to an object of class \code{tidyLPA}.
}
\examples{
\dontrun{
library(MplusAutomation)
createMixtures(classes = 1:4, filename_stem = "cars",
               model_overall = "wt ON drat;",
               model_class_specific = "wt;  qsec;",
               rdata = mtcars,
               usevariables = c("wt", "qsec", "drat"),
               OUTPUT = "standardized")
runModels(replaceOutfile = "modifiedDate")
cars_results <- readModels(filefilter = "cars")
results_tidyLPA <- as.tidyLPA(cars_results)
results_tidyLPA
plot(results_tidyLPA)
plot_profiles(results_tidyLPA) # Throws error; missing column 'Classes'
}
}
\author{
Caspar J. van Lissa
}
\keyword{internal}
