% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micro_forest.R
\name{micro_forest}
\alias{micro_forest}
\title{Create forest plots from negative binomial taxa models}
\usage{
micro_forest(
  modsum,
  ...,
  main,
  ylab,
  xlab,
  subtitle,
  legend_title,
  legend_labs
)
}
\arguments{
\item{modsum}{The output from nb_mods}

\item{...}{The covariate you'd like to plot. Must be in the models created by nb_mods}

\item{main}{The title for your plot}

\item{ylab}{The label for the y-axis; default is "Taxa"}

\item{xlab}{The label for the x-axis; default is output from function "TeX"}

\item{subtitle}{The plot subtitle}

\item{legend_title}{The title of the plot's legend}

\item{legend_labs}{The names of the elements within the legend}
}
\value{
Returns a ggplot that you can add geoms to if you'd like
}
\description{
Create forest plots for specified coefficients in negative binomial taxa models. Plots estimated beta coefficients and confidence intervals
}
\examples{
data(bpd_phy); data(bpd_cla); data(bpd_ord); data(bpd_fam); data(bpd_clin)

otu_tabs <- list(Phylum = bpd_phy, Class = bpd_cla,
Order = bpd_ord, Family = bpd_fam)
set <- tidy_micro(otu_tabs = otu_tabs, clinical = bpd_clin) \%>\%
filter(day == 7) ## Only including the first week

## Creating negative binomial models on filtered tidi_micro set
nb_fam <- set \%>\%
otu_filter(prev_cutoff = 5, ra_cutoff = 0.1,
exclude_taxa = c("Unclassified", "Bacteria")) \%>\%
nb_mods(table = "Family", bpd1)

nb_fam \%>\% micro_forest(bpd1)
}
