% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gather_array.r
\name{gather_array}
\alias{gather_array}
\title{Stack a JSON array}
\usage{
gather_array(x, column.name = "array.index")
}
\arguments{
\item{x}{a tbl_json whose JSON attribute should always be an array}

\item{column.name}{the name to give to the array index column created}
}
\value{
a tbl_json with a new column (column.name) that captures the array
  index and JSON attribute extracted from the array
}
\description{
Given a JSON array, such as [1, 2, 3], gather_array will "stack" the array in
the tbl_json data.frame, by replicating each row of the data.frame by the
length of the corresponding JSON array. A new column (by default called
"array.index") will be added to keep track of the referenced position in the
array for each row of the resuling data.frame.
}
\details{
JSON can contain arrays of data, which can be simple vectors (fixed or varying
length integer, character or logical vectors). But they also often contain
lists of other objects (like a list of purchases for a user). The function
gather_array() takes JSON arrays and duplicates the rows in the data.frame to
correspond to the indices of the array, and puts the elements of
the array into the JSON attribute. This is equivalent to "stacking" the array
in the data.frame, and lets you continue to manipulate the remaining JSON
in the elements of the array. For simple arrays, use append_values_* to
capture all of the values of the array. For more complex arrays (where the
values are themselves objects or arrays), continue using other tidyjson
functions to structure the data as needed.
}
\examples{
library(magrittr)  # for \%>\%
'[1, "a", {"k": "v"}]' \%>\% gather_array \%>\% json_types
}

