% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-methods.R
\name{augment.tidylda}
\alias{augment.tidylda}
\title{Augment method for \code{tidylda} objects}
\usage{
\method{augment}{tidylda}(
  x,
  data,
  type = c("class", "prob"),
  document_col = "document",
  term_col = "term",
  ...
)
}
\arguments{
\item{x}{an object of class \code{tidylda}}

\item{data}{a tidy tibble containing one row per original document-token pair, 
such as is returned by \link[tidytext]{tdm_tidiers} with column names
c("document", "term") at a minimum.}

\item{type}{one of either "class" or "prob"}

\item{document_col}{character specifying the name of the column that
corresponds to document IDs. Defaults to \code{"document"}.}

\item{term_col}{character specifying the name of the column that
corresponds to term/token IDs. Defaults to \code{"term"}.}

\item{...}{other arguments passed to methods,currently not used}
}
\value{
\code{augment} returns a tidy tibble containing one row per document-token
  pair, with one or more columns appended, depending on the value of \code{type}.
  
  If \code{type = 'prob'}, then one column per topic is appended. Its value
  is P(topic | document, token).
  
  If \code{type = 'class'}, then the most-probable topic for each document-token
  pair is returned. If multiple topics are equally probable, then the topic
  with the smallest index is returned by default.
}
\description{
\code{augment} appends observation level model outputs.
}
\details{
The key statistic for \code{augment} is P(topic | document, token) =
  P(topic | token) * P(token | document). P(topic | token) are the entries
  of the 'lambda' matrix in the \code{\link[tidylda]{tidylda}} object passed
  with \code{x}. P(token | document) is taken to be the frequency of each
  token normalized within each document.
}
