% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx_pvls_den.R
\name{tx_pvls_den}
\alias{tx_pvls_den}
\title{Subset Clients who have a Documented Viral Load Result}
\usage{
tx_pvls_den(
  data,
  ref = NULL,
  states = NULL,
  facilities = NULL,
  status = "calculated"
)
}
\arguments{
\item{data}{An NDR dataframe imported using the `read_ndr().}

\item{ref}{Date provided in ISO8601 format ("yyyy-mm-dd"). Used to
determine clients who are eligible for viral load and should have a
documented result. The default is the date of analysis.}

\item{states}{The name(s) of the State(s) of interest. The default utilizes all
the states in the dataframe. If specifying more than one state, combine the
states using the \code{c()} e.g. \code{c("State 1", "State 2")}.}

\item{facilities}{The name(s) of the facilit(ies) of interest. Default is to utilize
all the facilities contained in the dataframe. If specifying more than one
facility, combine the facilities using the \code{c()} e.g.
\code{c("Facility 1", "Facility 2")}.}

\item{status}{Determines how the number of active clients is calculated.
The options are to either to use the NDR current_status_28_days column
or the derived current_status column ("calculated").}
}
\value{
tx_pvls_den
}
\description{
Generate the line-list of clients whose date of last viral load result is not
more than one year (for adults 20 years and above) and 6 months (for
pediatrics and adolescents) from the specified reference date.
}
\examples{
tx_pvls_den(ndr_example, status = "default")

# Determine clients who are virally suppressed for two state at the end of Q4
tx_pvls_den(ndr_example,
  ref = "2021-09-30",
  states = c("Okun", "Arewa")
)
}
