% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct.R
\name{reframe_with_dct_smooth}
\alias{reframe_with_dct_smooth}
\title{Reframe with DCT Smooth}
\usage{
reframe_with_dct_smooth(
  .data,
  ...,
  .token_id_col,
  .by = NULL,
  .time_col = NULL,
  .order = 5,
  .rate = FALSE,
  .accel = FALSE
)
}
\arguments{
\item{.data}{A data frame}

\item{...}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} One or more unquoted
expressions separated by commas. These should target the vowel formant.}

\item{.token_id_col}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} The token ID column.}

\item{.by}{\code{\link[dplyr:dplyr_tidy_select]{<tidy-select>}} A grouping column.}

\item{.time_col}{A time column.}

\item{.order}{The number of DCT parameters to return. If \code{NA}, all DCT
parameters will be returned.}

\item{.rate}{Whether or not to include the rate of change of signal.}

\item{.accel}{Whether or not to include acceleration of signal.}
}
\value{
A data frame where the target columns have been smoothed using the
DCT, as well as the signal rate of change and acceleration,
if requested.
}
\description{
Apply a DCT Smooth to the targeted data
}
\details{
This is roughly equivalent to applying \link{reframe_with_dct} followed by
\link{reframe_with_idct}. As long as the value passed to \code{.order} is less than
the length of the each token's data, this will result in a smoothed version
of the data.
\subsection{Identifying tokens}{

The DCT only works on a by-token basis, so there must be a column that
uniquely identifies (or, in combination with a \code{.by} grouping, uniquely
identifies) each individual token. This column should be passed to
\code{.token_id_col}.
}

\subsection{Order}{

The number of DCT coefficients to return is defined by \code{.order}. The default
value is 5. Larger numbers will lead to less smoothing when the Inverse
DCT is applied (see \link{idct}). Smaller numbers will lead to more smoothing.

If \code{NA} is passed to \code{.order}, all DCT parameters will be returned, which
when the Inverse DCT is supplied, will completely reconstruct the original
data.
}

\subsection{Sorting by Time}{

An optional \code{.time_col} can also be defined to ensure that the data is
correctly arranged by time.

Additionally, if \code{.time_col} is provided, the original time column will
be included in the output
}
}
\examples{
library(tidynorm)
library(dplyr)

ggplot2_inst <- require(ggplot2)

speaker_small <- filter(
  speaker_tracks,
  id == 0
)

speaker_dct_smooth <- speaker_small |>
  reframe_with_dct_smooth(
    F1:F3,
    .by = speaker,
    .token_id_col = id,
    .time_col = t,
    .order = 5
  )

if (ggplot2_inst) {
  speaker_small |>
    ggplot(
      aes(
        t, F1
      )
    ) +
    geom_point() +
    facet_wrap(
      ~speaker,
      scales = "free_x",
      ncol = 1
    ) +
    labs(
      title = "Original Data"
    )
}

if (ggplot2_inst) {
  speaker_dct_smooth |>
    ggplot(
      aes(
        t, F1
      )
    ) +
    geom_point() +
    facet_wrap(
      ~speaker,
      scales = "free_x",
      ncol = 1
    ) +
    labs(
      title = "Smoothed Data"
    )
}
}
